/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.metric.undirected;

import java.io.IOException;
import java.text.NumberFormat;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.accumulators.LongMaximum;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.AnalyticHelper;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAnalyticBase;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.degree.annotate.undirected.VertexDegree;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.types.LongValue;

public class VertexMetrics<K extends Comparable<K>, VV, EV>
extends GraphAnalyticBase<K, VV, EV, Result> {
    private static final String VERTEX_COUNT = "vertexCount";
    private static final String EDGE_COUNT = "edgeCount";
    private static final String TRIPLET_COUNT = "tripletCount";
    private static final String MAXIMUM_DEGREE = "maximumDegree";
    private static final String MAXIMUM_TRIPLETS = "maximumTriplets";
    private VertexMetricsHelper<K> vertexMetricsHelper;
    private boolean includeZeroDegreeVertices = false;
    private boolean reduceOnTargetId = false;

    public VertexMetrics<K, VV, EV> setIncludeZeroDegreeVertices(boolean includeZeroDegreeVertices) {
        this.includeZeroDegreeVertices = includeZeroDegreeVertices;
        return this;
    }

    public VertexMetrics<K, VV, EV> setReduceOnTargetId(boolean reduceOnTargetId) {
        this.reduceOnTargetId = reduceOnTargetId;
        return this;
    }

    public VertexMetrics<K, VV, EV> run(Graph<K, VV, EV> input) throws Exception {
        super.run(input);
        DataSet vertexDegree = (DataSet)input.run(new VertexDegree().setIncludeZeroDegreeVertices(this.includeZeroDegreeVertices).setReduceOnTargetId(this.reduceOnTargetId).setParallelism(this.parallelism));
        this.vertexMetricsHelper = new VertexMetricsHelper();
        vertexDegree.output(this.vertexMetricsHelper).name("Vertex metrics");
        return this;
    }

    @Override
    public Result getResult() {
        long vertexCount = (Long)this.vertexMetricsHelper.getAccumulator(this.env, VERTEX_COUNT);
        long edgeCount = (Long)this.vertexMetricsHelper.getAccumulator(this.env, EDGE_COUNT);
        long tripletCount = (Long)this.vertexMetricsHelper.getAccumulator(this.env, TRIPLET_COUNT);
        long maximumDegree = (Long)this.vertexMetricsHelper.getAccumulator(this.env, MAXIMUM_DEGREE);
        long maximumTriplets = (Long)this.vertexMetricsHelper.getAccumulator(this.env, MAXIMUM_TRIPLETS);
        return new Result(vertexCount, edgeCount / 2L, tripletCount, maximumDegree, maximumTriplets);
    }

    public static class Result
    implements PrintableResult {
        private long vertexCount;
        private long edgeCount;
        private long tripletCount;
        private long maximumDegree;
        private long maximumTriplets;

        public Result(long vertexCount, long edgeCount, long tripletCount, long maximumDegree, long maximumTriplets) {
            this.vertexCount = vertexCount;
            this.edgeCount = edgeCount;
            this.tripletCount = tripletCount;
            this.maximumDegree = maximumDegree;
            this.maximumTriplets = maximumTriplets;
        }

        public long getNumberOfVertices() {
            return this.vertexCount;
        }

        public long getNumberOfEdges() {
            return this.edgeCount;
        }

        public double getAverageDegree() {
            return this.vertexCount == 0L ? Double.NaN : (double)(2L * this.edgeCount) / (double)this.vertexCount;
        }

        public double getDensity() {
            return this.vertexCount <= 1L ? Double.NaN : (double)this.edgeCount / (double)(this.vertexCount * (this.vertexCount - 1L) / 2L);
        }

        public long getNumberOfTriplets() {
            return this.tripletCount;
        }

        public long getMaximumDegree() {
            return this.maximumDegree;
        }

        public long getMaximumTriplets() {
            return this.maximumTriplets;
        }

        public String toString() {
            return this.toPrintableString();
        }

        @Override
        public String toPrintableString() {
            NumberFormat nf = NumberFormat.getInstance();
            NumberFormat ff = NumberFormat.getInstance();
            ff.setMaximumFractionDigits(8);
            return "vertex count: " + nf.format(this.vertexCount) + "; edge count: " + nf.format(this.edgeCount) + "; average degree: " + nf.format(this.getAverageDegree()) + "; density: " + ff.format(this.getDensity()) + "; triplet count: " + nf.format(this.tripletCount) + "; maximum degree: " + nf.format(this.maximumDegree) + "; maximum triplets: " + nf.format(this.maximumTriplets);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.vertexCount).append(this.edgeCount).append(this.tripletCount).append(this.maximumDegree).append(this.maximumTriplets).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Result rhs = (Result)obj;
            return new EqualsBuilder().append(this.vertexCount, rhs.vertexCount).append(this.edgeCount, rhs.edgeCount).append(this.tripletCount, rhs.tripletCount).append(this.maximumDegree, rhs.maximumDegree).append(this.maximumTriplets, rhs.maximumTriplets).isEquals();
        }
    }

    private static class VertexMetricsHelper<T>
    extends AnalyticHelper<Vertex<T, LongValue>> {
        private long vertexCount;
        private long edgeCount;
        private long tripletCount;
        private long maximumDegree;
        private long maximumTriplets;

        private VertexMetricsHelper() {
        }

        public void writeRecord(Vertex<T, LongValue> record) throws IOException {
            long degree = ((LongValue)record.f1).getValue();
            long triplets = degree * (degree - 1L) / 2L;
            ++this.vertexCount;
            this.edgeCount += degree;
            this.tripletCount += triplets;
            this.maximumDegree = Math.max(this.maximumDegree, degree);
            this.maximumTriplets = Math.max(this.maximumTriplets, triplets);
        }

        public void close() throws IOException {
            this.addAccumulator(VertexMetrics.VERTEX_COUNT, new LongCounter(this.vertexCount));
            this.addAccumulator(VertexMetrics.EDGE_COUNT, new LongCounter(this.edgeCount));
            this.addAccumulator(VertexMetrics.TRIPLET_COUNT, new LongCounter(this.tripletCount));
            this.addAccumulator(VertexMetrics.MAXIMUM_DEGREE, new LongMaximum(this.maximumDegree));
            this.addAccumulator(VertexMetrics.MAXIMUM_TRIPLETS, new LongMaximum(this.maximumTriplets));
        }
    }
}

