/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.ValueArray;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.NullValue;

public class NullValueArray
implements ValueArray<NullValue> {
    private int position;
    private transient int mark;
    private IntValue hashValue = new IntValue();
    private final ReadIterator iterator = new ReadIterator();

    public NullValueArray() {
    }

    public NullValueArray(int bytes) {
        this();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int idx = 0; idx < this.position; ++idx) {
            sb.append("\u2205");
            if (idx >= this.position - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<NullValue> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.position);
    }

    public void read(DataInputView in) throws IOException {
        this.position = in.readInt();
        this.mark = 0;
    }

    public int getMaxNormalizedKeyLen() {
        return this.hashValue.getMaxNormalizedKeyLen();
    }

    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        this.hashValue.setValue(this.position);
        this.hashValue.copyNormalizedKey(target, offset, len);
    }

    public int compareTo(ValueArray<NullValue> o) {
        NullValueArray other = (NullValueArray)o;
        return Integer.compare(this.position, other.position);
    }

    public int hashCode() {
        return this.position;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NullValueArray) {
            NullValueArray other = (NullValueArray)obj;
            return this.position == other.position;
        }
        return false;
    }

    public void setValue(ValueArray<NullValue> value) {
        value.copyTo(this);
    }

    public int getBinaryLength() {
        return this.hashValue.getBinaryLength();
    }

    public void copyTo(ValueArray<NullValue> target) {
        NullValueArray other = (NullValueArray)target;
        other.position = this.position;
    }

    public ValueArray<NullValue> copy() {
        NullValueArray copy = new NullValueArray();
        this.copyTo(copy);
        return copy;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, this.getBinaryLength());
    }

    @Override
    public int size() {
        return this.position;
    }

    @Override
    public boolean isFull() {
        return this.position == Integer.MAX_VALUE;
    }

    @Override
    public boolean add(NullValue value) {
        if (this.position == Integer.MAX_VALUE) {
            return false;
        }
        ++this.position;
        return true;
    }

    @Override
    public boolean addAll(ValueArray<NullValue> other) {
        NullValueArray source = (NullValueArray)other;
        long newPosition = (long)this.position + (long)source.position;
        if (newPosition > Integer.MAX_VALUE) {
            return false;
        }
        this.position = (int)newPosition;
        return true;
    }

    @Override
    public void clear() {
        this.position = 0;
    }

    @Override
    public void mark() {
        this.mark = this.position;
    }

    @Override
    public void reset() {
        this.position = this.mark;
    }

    private class ReadIterator
    implements Iterator<NullValue> {
        private int pos;

        private ReadIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < NullValueArray.this.position;
        }

        @Override
        public NullValue next() {
            ++this.pos;
            return NullValue.getInstance();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public void reset() {
            this.pos = 0;
        }
    }
}

