/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.ValueArray;
import org.apache.flink.graph.utils.MurmurHash;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.util.Preconditions;

public class ShortValueArray
implements ValueArray<ShortValue> {
    protected static final int ELEMENT_LENGTH_IN_BYTES = 2;
    protected static final int DEFAULT_CAPACITY_IN_BYTES = 1024;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private boolean isBounded;
    private short[] data;
    private int position;
    private transient int mark;
    private MurmurHash hash = new MurmurHash(-1290498431);
    private IntValue hashValue = new IntValue();
    private final ReadIterator iterator = new ReadIterator();

    public ShortValueArray() {
        this.isBounded = false;
        this.initialize(1024);
    }

    public ShortValueArray(int bytes) {
        this.isBounded = true;
        this.initialize(bytes);
    }

    private void initialize(int bytes) {
        int capacity = bytes / 2;
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"Requested array with zero capacity");
        Preconditions.checkArgument((capacity <= 0x7FFFFFF7 ? 1 : 0) != 0, (Object)"Requested capacity exceeds limit of 2147483639");
        this.data = new short[capacity];
    }

    private void ensureCapacity(int minCapacity) {
        long currentCapacity = this.data.length;
        if ((long)minCapacity <= currentCapacity) {
            return;
        }
        long expandedCapacity = Math.max((long)minCapacity, currentCapacity + (currentCapacity >> 1));
        int newCapacity = (int)Math.min(0x7FFFFFF7L, expandedCapacity);
        if (newCapacity < minCapacity) {
            throw new RuntimeException("Requested array size " + minCapacity + " exceeds limit of " + 0x7FFFFFF7);
        }
        this.data = Arrays.copyOf(this.data, newCapacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int idx = 0; idx < this.position; ++idx) {
            sb.append(this.data[idx]);
            if (idx >= this.position - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<ShortValue> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.position);
        for (int i = 0; i < this.position; ++i) {
            out.writeShort((int)this.data[i]);
        }
    }

    public void read(DataInputView in) throws IOException {
        this.position = in.readInt();
        this.mark = 0;
        this.ensureCapacity(this.position);
        for (int i = 0; i < this.position; ++i) {
            this.data[i] = in.readShort();
        }
    }

    public int getMaxNormalizedKeyLen() {
        return this.hashValue.getMaxNormalizedKeyLen();
    }

    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        this.hash.reset();
        this.hash.hash(this.position);
        for (int i = 0; i < this.position; ++i) {
            this.hash.hash(this.data[i]);
        }
        this.hashValue.setValue(this.hash.hash());
        this.hashValue.copyNormalizedKey(target, offset, len);
    }

    public int compareTo(ValueArray<ShortValue> o) {
        ShortValueArray other = (ShortValueArray)o;
        int min = Math.min(this.position, other.position);
        for (int i = 0; i < min; ++i) {
            int cmp = Short.compare(this.data[i], other.data[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(this.position, other.position);
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.position; ++i) {
            hash = 31 * hash + this.data[i];
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShortValueArray) {
            ShortValueArray other = (ShortValueArray)obj;
            if (this.position != other.position) {
                return false;
            }
            for (int i = 0; i < this.position; ++i) {
                if (this.data[i] == other.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setValue(ValueArray<ShortValue> value) {
        value.copyTo(this);
    }

    public int getBinaryLength() {
        return -1;
    }

    public void copyTo(ValueArray<ShortValue> target) {
        ShortValueArray other = (ShortValueArray)target;
        other.position = this.position;
        other.mark = this.mark;
        other.ensureCapacity(this.position);
        System.arraycopy(this.data, 0, other.data, 0, this.position);
    }

    public ValueArray<ShortValue> copy() {
        ShortValueArray copy = new ShortValueArray();
        this.copyTo(copy);
        return copy;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        ShortValueArray.copyInternal(source, target);
    }

    protected static void copyInternal(DataInputView source, DataOutputView target) throws IOException {
        int count = source.readInt();
        target.writeInt(count);
        int bytes = 2 * count;
        target.write(source, bytes);
    }

    @Override
    public int size() {
        return this.position;
    }

    @Override
    public boolean isFull() {
        if (this.isBounded) {
            return this.position == this.data.length;
        }
        return this.position == 0x7FFFFFF7;
    }

    @Override
    public boolean add(ShortValue value) {
        int newPosition = this.position + 1;
        if (newPosition > this.data.length) {
            if (this.isBounded) {
                return false;
            }
            this.ensureCapacity(newPosition);
        }
        this.data[this.position] = value.getValue();
        this.position = newPosition;
        return true;
    }

    @Override
    public boolean addAll(ValueArray<ShortValue> other) {
        ShortValueArray source = (ShortValueArray)other;
        int sourceSize = source.position;
        int newPosition = this.position + sourceSize;
        if (newPosition > this.data.length) {
            if (this.isBounded) {
                return false;
            }
            this.ensureCapacity(newPosition);
        }
        System.arraycopy(source.data, 0, this.data, this.position, sourceSize);
        this.position = newPosition;
        return true;
    }

    @Override
    public void clear() {
        this.position = 0;
    }

    @Override
    public void mark() {
        this.mark = this.position;
    }

    @Override
    public void reset() {
        this.position = this.mark;
    }

    private class ReadIterator
    implements Iterator<ShortValue> {
        private ShortValue value = new ShortValue();
        private int pos;

        private ReadIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < ShortValueArray.this.position;
        }

        @Override
        public ShortValue next() {
            this.value.setValue(ShortValueArray.this.data[this.pos++]);
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public void reset() {
            this.pos = 0;
        }
    }
}

