INSERT INTO "{dld_database}"."{dld_table}_staging"
SELECT 
	FORMAT_INT("area_id") AS "area_id",
	FORMAT_INT("zone_id") AS "zone_id",
	FORMAT_INT("parcel_id") AS "parcel_id",
	FORMAT_INT("land_number") AS "land_number",
	FORMAT_INT("land_sub_number") AS "land_sub_number",
	FORMAT_INT("land_type_id") AS "land_type_id",
	FORMAT_INT("master_project_id") AS "master_project_id", 
	FORMAT_VARCHAR("master_project_en") AS "master_project_en", 
	FORMAT_VARCHAR("master_project_ar") AS "master_project_ar",
	FORMAT_INT("project_id") AS "project_id",
	FORMAT_VARCHAR("project_name_ar") AS "project_name_ar", 
	FORMAT_VARCHAR("project_name_en") AS "project_name_en",
	FORMAT_VARCHAR("building_number") AS "building_number",
	FORMAT_INT("parent_property_id") AS "parent_property_id",
	FORMAT_INT("property_id") AS "property_id",
	FORMAT_INT("property_sub_type_id") AS "property_sub_type_id",
	FORMAT_BOOL("is_free_hold") AS "is_free_hold", 
	FORMAT_BOOL("is_lease_hold") AS "is_lease_hold", 
	FORMAT_BOOL("is_registered") AS "is_registered",
	FORMAT_VARCHAR("pre_registration_number") AS "pre_registration_number",
	FORMAT_DATE("creation_date") AS "creation_date",
	FORMAT_FLOAT("built_up_area") AS "built_up_area",
	FORMAT_FLOAT("common_area") AS "common_area",
	FORMAT_INT("actual_common_area") AS "actual_common_area",
	FORMAT_FLOAT("actual_area") AS "actual_area",
	FORMAT_INT("bld_levels") AS "bld_levels",
	FORMAT_INT("floors") AS "floors",
	FORMAT_VARCHAR("rooms_en") AS "rooms_en", 
	FORMAT_INT("car_parks") AS "car_parks",
	FORMAT_INT("elevators") AS "elevators",
	FORMAT_INT("swimming_pools") AS "swimming_pools",
	FORMAT_INT("offices") AS "offices",
	FORMAT_INT("shops") AS "shops",
	FORMAT_INT("flats") AS "flats"
FROM url(
    'https://www.dubaipulse.gov.ae/dataset/04168da5-9d10-4fe3-bd29-6dba97751435/resource/6450b4a5-f9c5-4aca-8e64-b38aa8db4c5a/download/buildings.csv',
    'CSVWithNames'
);