#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  style_picker.py
#
#  Copyright 2019 Dominic Davis-Foster <dominic@davis-foster.co.uk>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
#
#
# generated by wxGlade 0.9.3 on Tue Apr  9 18:07:58 2019
#

# stdlib
import sys

# 3rd party
import wx

# this package
from domdf_wxpython_tools.StylePickerPanel import StylePickerPanel, default_styles
from domdf_wxpython_tools.ColourPickerPanel import ColourPickerPanel, default_colours


# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode
# end wxGlade


class style_picker(wx.Dialog):
	def __init__(
			self, parent, title="Choose Styles", label="Choose Styles: ",
			selection_choices=None, *args, **kwds
			):
		
		self.title = title
		
		args = (parent,) + args
		# begin wxGlade: style_picker.__init__
		kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)
		self.StylePickerPanel = StylePickerPanel(self, label=label, selection_choices=selection_choices)
		self.button_panel = wx.Panel(self, wx.ID_ANY)
		self.cancel_btn = wx.Button(self.button_panel, wx.ID_ANY, "Cancel")
		self.apply_btn = wx.Button(self.button_panel, wx.ID_ANY, "Apply")

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_BUTTON, self.cancel, self.cancel_btn)
		self.Bind(wx.EVT_BUTTON, self.apply, self.apply_btn)
		# end wxGlade
	
	def __set_properties(self):
		# begin wxGlade: style_picker.__set_properties
		self.SetTitle("Choose Styles")
		# end wxGlade
		self.SetTitle(self.title)
	
	def __do_layout(self):
		# begin wxGlade: style_picker.__do_layout
		parent_sizer = wx.FlexGridSizer(2, 1, 0, 0)
		button_grid = wx.GridSizer(1, 2, 0, 5)
		parent_sizer.Add(self.StylePickerPanel, 1, wx.EXPAND, 0)
		button_grid.Add(self.cancel_btn, 0, wx.ALIGN_CENTER, 0)
		button_grid.Add(self.apply_btn, 0, wx.ALIGN_CENTER, 0)
		self.button_panel.SetSizer(button_grid)
		parent_sizer.Add(self.button_panel, 1, wx.ALIGN_BOTTOM | wx.ALIGN_RIGHT | wx.ALL, 5)
		self.SetSizer(parent_sizer)
		parent_sizer.Fit(self)
		self.Layout()
		# end wxGlade

	def cancel(self, _):  # wxGlade: style_picker.<event_handler>
		self.Destroy()
	
	def apply(self, event):  # wxGlade: style_picker.<event_handler>
		self.style_list = self.StylePickerPanel.get_selection()
		event.Skip()
		self.EndModal(wx.ID_OK)

# end of class style_picker


class colour_picker(style_picker):
	def __init__(
			self, parent, title="Choose Colours", label="Choose Colours: ",
			picker_choices=None, selection_choices=None, *args, **kwds
			):
		
		self.title = title
		self.picker_choices = picker_choices

		args = (parent,) + args

		kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)
		self.StylePickerPanel = ColourPickerPanel(self, label=label, picker_choices=picker_choices, selection_choices=selection_choices)
		self.button_panel = wx.Panel(self, wx.ID_ANY)
		self.cancel_btn = wx.Button(self.button_panel, wx.ID_ANY, "Cancel")
		self.apply_btn = wx.Button(self.button_panel, wx.ID_ANY, "Apply")

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_BUTTON, self.cancel, self.cancel_btn)
		self.Bind(wx.EVT_BUTTON, self.apply, self.apply_btn)

	
	def apply(self, event):
		self.colour_list = self.StylePickerPanel.get_selection()
		event.Skip()
		self.EndModal(wx.ID_OK)
	
	def __set_properties(self):
		# begin wxGlade: style_picker.__set_properties
		self.SetTitle("Choose Styles")
		# end wxGlade
		self.SetTitle(self.title)
	
	def __do_layout(self):
		# begin wxGlade: style_picker.__do_layout
		parent_sizer = wx.FlexGridSizer(2, 1, 0, 0)
		button_grid = wx.GridSizer(1, 2, 0, 5)
		parent_sizer.Add(self.StylePickerPanel, 1, wx.EXPAND, 0)
		button_grid.Add(self.cancel_btn, 0, wx.ALIGN_CENTER, 0)
		button_grid.Add(self.apply_btn, 0, wx.ALIGN_CENTER, 0)
		self.button_panel.SetSizer(button_grid)
		parent_sizer.Add(self.button_panel, 1, wx.ALIGN_BOTTOM | wx.ALIGN_RIGHT | wx.ALL, 5)
		self.SetSizer(parent_sizer)
		parent_sizer.Fit(self)
		self.Layout()
		# end wxGlade
