import { Construct, IResource, Resource } from '@aws-cdk/core';
import { IKey } from './key';
/**
 * A KMS Key alias.
 */
export interface IAlias extends IResource {
    /**
     * The name of the alias.
     *
     * @attribute
     */
    readonly aliasName: string;
    /**
     * The Key to which the Alias refers.
     *
     * @attribute
     */
    readonly aliasTargetKey: IKey;
}
/**
 * Construction properties for a KMS Key Alias object.
 */
export interface AliasProps {
    /**
     * The name of the alias. The name must start with alias followed by a
     * forward slash, such as alias/. You can't specify aliases that begin with
     * alias/AWS. These aliases are reserved.
     */
    readonly aliasName: string;
    /**
     * The ID of the key for which you are creating the alias. Specify the key's
     * globally unique identifier or Amazon Resource Name (ARN). You can't
     * specify another alias.
     */
    readonly targetKey: IKey;
}
declare abstract class AliasBase extends Resource implements IAlias {
    abstract readonly aliasName: string;
    abstract readonly aliasTargetKey: IKey;
}
export interface AliasAttributes {
    readonly aliasName: string;
    readonly aliasTargetKey: IKey;
}
/**
 * Defines a display name for a customer master key (CMK) in AWS Key Management
 * Service (AWS KMS). Using an alias to refer to a key can help you simplify key
 * management. For example, when rotating keys, you can just update the alias
 * mapping instead of tracking and changing key IDs. For more information, see
 * Working with Aliases in the AWS Key Management Service Developer Guide.
 *
 * You can also add an alias for a key by calling `key.addAlias(alias)`.
 *
 * @resource AWS::KMS::Alias
 */
export declare class Alias extends AliasBase {
    static fromAliasAttributes(scope: Construct, id: string, attrs: AliasAttributes): IAlias;
    readonly aliasName: string;
    readonly aliasTargetKey: IKey;
    constructor(scope: Construct, id: string, props: AliasProps);
}
export {};
