from .utils.json_map import JsonMap
from .utils.base_model import BaseModel


@JsonMap(
    {
        "purchase_id": "purchaseId",
        "new_start_date": "newStartDate",
        "new_end_date": "newEndDate",
        "new_start_time": "newStartTime",
        "new_end_time": "newEndTime",
    }
)
class EditPurchaseOkResponse(BaseModel):
    """EditPurchaseOkResponse

    :param purchase_id: ID of the purchase, defaults to None
    :type purchase_id: str, optional
    :param new_start_date: Start date of the package's validity in the format 'yyyy-MM-ddThh:mm:ssZZ', defaults to None
    :type new_start_date: str, optional
    :param new_end_date: End date of the package's validity in the format 'yyyy-MM-ddThh:mm:ssZZ', defaults to None
    :type new_end_date: str, optional
    :param new_start_time: Epoch value representing the new start time of the package's validity, defaults to None
    :type new_start_time: float, optional
    :param new_end_time: Epoch value representing the new end time of the package's validity, defaults to None
    :type new_end_time: float, optional
    """

    def __init__(
        self,
        purchase_id: str = None,
        new_start_date: str = None,
        new_end_date: str = None,
        new_start_time: float = None,
        new_end_time: float = None,
    ):
        self.purchase_id = purchase_id
        self.new_start_date = new_start_date
        self.new_end_date = new_end_date
        self.new_start_time = new_start_time
        self.new_end_time = new_end_time
