# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from typing import Dict, List, Optional

from pydantic.v1 import Field, StrictInt, StrictStr, validate_arguments
from typing_extensions import Annotated

from earnix_elevate.clients.data.api_client import ApiClient
from earnix_elevate.clients.data.api_response import ApiResponse
from earnix_elevate.clients.data.exceptions import ApiTypeError
from earnix_elevate.clients.data.models.add_data_set_node_request import (
    AddDataSetNodeRequest,
)
from earnix_elevate.clients.data.models.create_data_set_request import (
    CreateDataSetRequest,
)
from earnix_elevate.clients.data.models.create_data_set_version_request import (
    CreateDataSetVersionRequest,
)
from earnix_elevate.clients.data.models.data_set_node_response import (
    DataSetNodeResponse,
)
from earnix_elevate.clients.data.models.data_set_response import DataSetResponse
from earnix_elevate.clients.data.models.execute_recipe_request import (
    ExecuteRecipeRequest,
)
from earnix_elevate.clients.data.models.export_s3_request import ExportS3Request
from earnix_elevate.clients.data.models.export_s3_response import ExportS3Response
from earnix_elevate.clients.data.models.lean_transformation_graph_response import (
    LeanTransformationGraphResponse,
)
from earnix_elevate.clients.data.models.recipe_status_response import (
    RecipeStatusResponse,
)
from earnix_elevate.clients.data.models.schema_analysis_status_response import (
    SchemaAnalysisStatusResponse,
)
from earnix_elevate.clients.data.models.transformation_graph_wrapper_response import (
    TransformationGraphWrapperResponse,
)
from earnix_elevate.clients.data.models.update_data_set_node_request import (
    UpdateDataSetNodeRequest,
)
from earnix_elevate.clients.data.models.update_data_set_request import (
    UpdateDataSetRequest,
)


class DataSetServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def add_data_set_node_to_transformaion_graph(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        add_data_set_node_request: Annotated[
            AddDataSetNodeRequest,
            Field(
                ...,
                description="Request body containing the configuration for adding a new node (recipe or DataTable) to a transformation graph",
            ),
        ],
        **kwargs,
    ) -> TransformationGraphWrapperResponse:
        """Adds a new node (recipe or DataTable) to the specified transformation graph version. For DataTable nodes, the node references a specific DataTable and optionally a specific version. For recipe nodes, the node contains transformation logic and creates edges to its source nodes. Transformation recipes can only have one DataTable as a source, while structure recipes can have multiple sources. Nodes represent data processing steps or data sources within the transformation workflow.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param add_data_set_node_request: Request body containing the configuration for adding a new node (recipe or DataTable) to a transformation graph (required)
        :type add_data_set_node_request: AddDataSetNodeRequest
        :return: Returns the result object.
        :rtype: TransformationGraphWrapperResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the add_data_set_node_to_transformaion_graph_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.add_data_set_node_to_transformaion_graph_with_http_info(
            data_set_id,
            transformation_graph_version_number,
            add_data_set_node_request,
            **kwargs,
        )

    @validate_arguments
    def add_data_set_node_to_transformaion_graph_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        add_data_set_node_request: Annotated[
            AddDataSetNodeRequest,
            Field(
                ...,
                description="Request body containing the configuration for adding a new node (recipe or DataTable) to a transformation graph",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Adds a new node (recipe or DataTable) to the specified transformation graph version. For DataTable nodes, the node references a specific DataTable and optionally a specific version. For recipe nodes, the node contains transformation logic and creates edges to its source nodes. Transformation recipes can only have one DataTable as a source, while structure recipes can have multiple sources. Nodes represent data processing steps or data sources within the transformation workflow.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param add_data_set_node_request: Request body containing the configuration for adding a new node (recipe or DataTable) to a transformation graph (required)
        :type add_data_set_node_request: AddDataSetNodeRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(TransformationGraphWrapperResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "add_data_set_node_request",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_data_set_node_to_transformaion_graph" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["add_data_set_node_request"] is not None:
            _body_params = _params["add_data_set_node_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "TransformationGraphWrapperResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def create_data_set(
        self,
        create_data_set_request: Annotated[
            CreateDataSetRequest,
            Field(
                ...,
                description="Request body containing the configuration details needed to create a new DataSet, including name, description, and initial metadata",
            ),
        ],
        **kwargs,
    ) -> DataSetResponse:
        """Creates a new DataSet that serves as a container for data transformation workflows. A DataSet can contain multiple versions, each representing a different configuration of the transformation graph with various DataTables and recipes.

        :param create_data_set_request: Request body containing the configuration details needed to create a new DataSet, including name, description, and initial metadata (required)
        :type create_data_set_request: CreateDataSetRequest
        :return: Returns the result object.
        :rtype: DataSetResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the create_data_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.create_data_set_with_http_info(create_data_set_request, **kwargs)

    @validate_arguments
    def create_data_set_with_http_info(
        self,
        create_data_set_request: Annotated[
            CreateDataSetRequest,
            Field(
                ...,
                description="Request body containing the configuration details needed to create a new DataSet, including name, description, and initial metadata",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Creates a new DataSet that serves as a container for data transformation workflows. A DataSet can contain multiple versions, each representing a different configuration of the transformation graph with various DataTables and recipes.

        :param create_data_set_request: Request body containing the configuration details needed to create a new DataSet, including name, description, and initial metadata (required)
        :type create_data_set_request: CreateDataSetRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataSetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["create_data_set_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_set" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["create_data_set_request"] is not None:
            _body_params = _params["create_data_set_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataSetResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def create_new_version_to_data_set(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        create_data_set_version_request: Annotated[
            CreateDataSetVersionRequest,
            Field(
                ...,
                description="Request body containing the configuration for creating a new version of a DataSet transformation graph",
            ),
        ],
        **kwargs,
    ) -> TransformationGraphWrapperResponse:
        """Creates a new version of the transformation graph for the specified DataSet. This operation increments both the latest and max version numbers of the DataSet. If sourceTransformationGraphVersionNumber is provided, the new version will be cloned from that version. If sourceTransformationGraphVersionNumber is 0, an empty version is created (but only if the source version has nodes). This allows you to create different configurations and iterations of your data transformation workflow.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param create_data_set_version_request: Request body containing the configuration for creating a new version of a DataSet transformation graph (required)
        :type create_data_set_version_request: CreateDataSetVersionRequest
        :return: Returns the result object.
        :rtype: TransformationGraphWrapperResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the create_new_version_to_data_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.create_new_version_to_data_set_with_http_info(
            data_set_id, create_data_set_version_request, **kwargs
        )

    @validate_arguments
    def create_new_version_to_data_set_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        create_data_set_version_request: Annotated[
            CreateDataSetVersionRequest,
            Field(
                ...,
                description="Request body containing the configuration for creating a new version of a DataSet transformation graph",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Creates a new version of the transformation graph for the specified DataSet. This operation increments both the latest and max version numbers of the DataSet. If sourceTransformationGraphVersionNumber is provided, the new version will be cloned from that version. If sourceTransformationGraphVersionNumber is 0, an empty version is created (but only if the source version has nodes). This allows you to create different configurations and iterations of your data transformation workflow.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param create_data_set_version_request: Request body containing the configuration for creating a new version of a DataSet transformation graph (required)
        :type create_data_set_version_request: CreateDataSetVersionRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(TransformationGraphWrapperResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_set_id", "create_data_set_version_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_new_version_to_data_set" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["create_data_set_version_request"] is not None:
            _body_params = _params["create_data_set_version_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "TransformationGraphWrapperResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_data_set(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        **kwargs,
    ) -> None:
        """Permanently deletes a DataSet and all its associated transformation graphs, versions, and metadata. This operation deletes the latest transformation graph and all its associated data. This operation cannot be undone and will remove all historical data processing configurations.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_data_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.delete_data_set_with_http_info(data_set_id, **kwargs)

    @validate_arguments
    def delete_data_set_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Permanently deletes a DataSet and all its associated transformation graphs, versions, and metadata. This operation deletes the latest transformation graph and all its associated data. This operation cannot be undone and will remove all historical data processing configurations.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["data_set_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_set" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_data_set_node_from_transformation_graph(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> None:
        """Deletes a specific node (recipe or dataTable) from the transformation graph version. This operation removes the node and all its associated edges from the graph.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_data_set_node_from_transformation_graph_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.delete_data_set_node_from_transformation_graph_with_http_info(
            data_set_id, transformation_graph_version_number, data_set_node_id, **kwargs
        )

    @validate_arguments
    def delete_data_set_node_from_transformation_graph_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Deletes a specific node (recipe or dataTable) from the transformation graph version. This operation removes the node and all its associated edges from the graph.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_set_node_from_transformation_graph" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_data_set_version(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        **kwargs,
    ) -> None:
        """Permanently deletes a specific version of the transformation graph. If the deleted version is the latest version, the DataSet's latest version number is decremented to the previous version. The last remaining version cannot be deleted. This operation cannot be undone and will remove all associated nodes, edges, and execution history for that version.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_data_set_version_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.delete_data_set_version_with_http_info(
            data_set_id, transformation_graph_version_number, **kwargs
        )

    @validate_arguments
    def delete_data_set_version_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Permanently deletes a specific version of the transformation graph. If the deleted version is the latest version, the DataSet's latest version number is decremented to the previous version. The last remaining version cannot be deleted. This operation cannot be undone and will remove all associated nodes, edges, and execution history for that version.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["data_set_id", "transformation_graph_version_number"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_set_version" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def execute_recipe(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        execute_recipe_request: Annotated[
            ExecuteRecipeRequest,
            Field(
                ...,
                description="Request body containing the execution parameters for running a recipe node within a transformation graph",
            ),
        ],
        **kwargs,
    ) -> DataSetNodeResponse:
        """Executes a recipe node within the transformation graph. This triggers the data processing logic defined in the recipe and returns the execution status and job information.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param execute_recipe_request: Request body containing the execution parameters for running a recipe node within a transformation graph (required)
        :type execute_recipe_request: ExecuteRecipeRequest
        :return: Returns the result object.
        :rtype: DataSetNodeResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the execute_recipe_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.execute_recipe_with_http_info(
            data_set_id,
            transformation_graph_version_number,
            data_set_node_id,
            execute_recipe_request,
            **kwargs,
        )

    @validate_arguments
    def execute_recipe_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        execute_recipe_request: Annotated[
            ExecuteRecipeRequest,
            Field(
                ...,
                description="Request body containing the execution parameters for running a recipe node within a transformation graph",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Executes a recipe node within the transformation graph. This triggers the data processing logic defined in the recipe and returns the execution status and job information.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param execute_recipe_request: Request body containing the execution parameters for running a recipe node within a transformation graph (required)
        :type execute_recipe_request: ExecuteRecipeRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataSetNodeResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
            "execute_recipe_request",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method execute_recipe" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["execute_recipe_request"] is not None:
            _body_params = _params["execute_recipe_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataSetNodeResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}/execute",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def export_data_set_node_to_s3(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        export_s3_request: Annotated[
            ExportS3Request,
            Field(
                ...,
                description="Request body containing S3 credentials and configuration details for exporting data to Amazon S3",
            ),
        ],
        **kwargs,
    ) -> ExportS3Response:
        """Initiates an export of the processed data from the output node to Amazon S3. This operation validates that the recipe node has been successfully executed before allowing the export. The export type (sample or full data) must match the execution type of the recipe. Returns a job ID that can be used to track the export progress and retrieve results.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param export_s3_request: Request body containing S3 credentials and configuration details for exporting data to Amazon S3 (required)
        :type export_s3_request: ExportS3Request
        :return: Returns the result object.
        :rtype: ExportS3Response
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the export_data_set_node_to_s3_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.export_data_set_node_to_s3_with_http_info(
            data_set_id,
            transformation_graph_version_number,
            data_set_node_id,
            export_s3_request,
            **kwargs,
        )

    @validate_arguments
    def export_data_set_node_to_s3_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        export_s3_request: Annotated[
            ExportS3Request,
            Field(
                ...,
                description="Request body containing S3 credentials and configuration details for exporting data to Amazon S3",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Initiates an export of the processed data from the output node to Amazon S3. This operation validates that the recipe node has been successfully executed before allowing the export. The export type (sample or full data) must match the execution type of the recipe. Returns a job ID that can be used to track the export progress and retrieve results.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param export_s3_request: Request body containing S3 credentials and configuration details for exporting data to Amazon S3 (required)
        :type export_s3_request: ExportS3Request
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ExportS3Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
            "export_s3_request",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_data_set_node_to_s3" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["export_s3_request"] is not None:
            _body_params = _params["export_s3_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ExportS3Response",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}/export-s3",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def export_data_set_version_to_s3(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        export_s3_request: Annotated[
            ExportS3Request,
            Field(
                ...,
                description="Request body containing S3 credentials and configuration details for exporting data to Amazon S3",
            ),
        ],
        **kwargs,
    ) -> ExportS3Response:
        """Initiates an export of the processed data from the output node to Amazon S3. This operation validates that the recipe node has been successfully executed before allowing the export. The export type (sample or full data) must match the execution type of the recipe. Returns a job ID that can be used to track the export progress and retrieve results.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param export_s3_request: Request body containing S3 credentials and configuration details for exporting data to Amazon S3 (required)
        :type export_s3_request: ExportS3Request
        :return: Returns the result object.
        :rtype: ExportS3Response
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the export_data_set_version_to_s3_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.export_data_set_version_to_s3_with_http_info(
            data_set_id,
            transformation_graph_version_number,
            export_s3_request,
            **kwargs,
        )

    @validate_arguments
    def export_data_set_version_to_s3_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        export_s3_request: Annotated[
            ExportS3Request,
            Field(
                ...,
                description="Request body containing S3 credentials and configuration details for exporting data to Amazon S3",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Initiates an export of the processed data from the output node to Amazon S3. This operation validates that the recipe node has been successfully executed before allowing the export. The export type (sample or full data) must match the execution type of the recipe. Returns a job ID that can be used to track the export progress and retrieve results.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param export_s3_request: Request body containing S3 credentials and configuration details for exporting data to Amazon S3 (required)
        :type export_s3_request: ExportS3Request
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ExportS3Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "export_s3_request",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_data_set_version_to_s3" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["export_s3_request"] is not None:
            _body_params = _params["export_s3_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ExportS3Response",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/export-s3",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_data_set(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        **kwargs,
    ) -> DataSetResponse:
        """Retrieves detailed information about a specific DataSet including its latest transformation graph, version history, and metadata. Returns NOT_FOUND if the DataSet does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :return: Returns the result object.
        :rtype: DataSetResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_data_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_data_set_with_http_info(data_set_id, **kwargs)

    @validate_arguments
    def get_data_set_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves detailed information about a specific DataSet including its latest transformation graph, version history, and metadata. Returns NOT_FOUND if the DataSet does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataSetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_set_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_set" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataSetResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_data_set_recipe_node_preview(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> List[Dict[str, object]]:
        """Retrieves a sample of the actual data content from a specific data set recipe node for preview purposes. Returns a limited number of rows to allow users to inspect the data structure and content without downloading the entire dataset.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :return: Returns the result object.
        :rtype: List[Dict[str, object]]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_data_set_recipe_node_preview_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_data_set_recipe_node_preview_with_http_info(
            data_set_id, transformation_graph_version_number, data_set_node_id, **kwargs
        )

    @validate_arguments
    def get_data_set_recipe_node_preview_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves a sample of the actual data content from a specific data set recipe node for preview purposes. Returns a limited number of rows to allow users to inspect the data structure and content without downloading the entire dataset.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[Dict[str, object]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_set_recipe_node_preview" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[Dict[str, object]]",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}/preview",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_latest_recipe_status(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> RecipeStatusResponse:
        """Retrieves the current execution status of a recipe node from the most recent execution. Returns only the numeric status code representing the execution state (e.g., 0=PENDING, 1=IN_PROGRESS, 2=COMPLETED, 3=FAILED).

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :return: Returns the result object.
        :rtype: RecipeStatusResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_latest_recipe_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_latest_recipe_status_with_http_info(
            data_set_id, transformation_graph_version_number, data_set_node_id, **kwargs
        )

    @validate_arguments
    def get_latest_recipe_status_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves the current execution status of a recipe node from the most recent execution. Returns only the numeric status code representing the execution state (e.g., 0=PENDING, 1=IN_PROGRESS, 2=COMPLETED, 3=FAILED).

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(RecipeStatusResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_recipe_status" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "RecipeStatusResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}/latest-recipe-status",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_recipe_node_column_analysis(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        column_name: Annotated[
            StrictStr,
            Field(
                ...,
                description="Name of the column to retrieve analysis for (must exist in the recipe result schema)",
            ),
        ],
        analysis_type: Annotated[
            Optional[StrictStr], Field(description="Preferred analysis type")
        ] = None,
        **kwargs,
    ) -> Dict[str, object]:
        """Retrieves schema analysis results for a single column of a recipe node execution result. Returns NOT_FOUND if the data set, transformation graph, node, column, or schema analysis does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param column_name: Name of the column to retrieve analysis for (must exist in the recipe result schema) (required)
        :type column_name: str
        :param analysis_type: Preferred analysis type
        :type analysis_type: str
        :return: Returns the result object.
        :rtype: Dict[str, object]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_recipe_node_column_analysis_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_recipe_node_column_analysis_with_http_info(
            data_set_id,
            transformation_graph_version_number,
            data_set_node_id,
            column_name,
            analysis_type,
            **kwargs,
        )

    @validate_arguments
    def get_recipe_node_column_analysis_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        column_name: Annotated[
            StrictStr,
            Field(
                ...,
                description="Name of the column to retrieve analysis for (must exist in the recipe result schema)",
            ),
        ],
        analysis_type: Annotated[
            Optional[StrictStr], Field(description="Preferred analysis type")
        ] = None,
        **kwargs,
    ) -> ApiResponse:
        """Retrieves schema analysis results for a single column of a recipe node execution result. Returns NOT_FOUND if the data set, transformation graph, node, column, or schema analysis does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param column_name: Name of the column to retrieve analysis for (must exist in the recipe result schema) (required)
        :type column_name: str
        :param analysis_type: Preferred analysis type
        :type analysis_type: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
            "column_name",
            "analysis_type",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipe_node_column_analysis" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        if _params["column_name"] is not None:
            _path_params["column-name"] = _params["column_name"]

        # process the query parameters
        _query_params = []
        if _params.get("analysis_type") is not None:
            _query_params.append(("analysisType", _params["analysis_type"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "Dict[str, object]",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}/schema-analysis/columns/{column-name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_recipe_node_overview(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        analysis_type: Annotated[
            Optional[StrictStr], Field(description="Preferred analysis type")
        ] = None,
        **kwargs,
    ) -> Dict[str, object]:
        """Retrieves schema overview statistics of a recipe node execution result. Returns NOT_FOUND if the data set, transformation graph, node, or schema overview does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param analysis_type: Preferred analysis type
        :type analysis_type: str
        :return: Returns the result object.
        :rtype: Dict[str, object]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_recipe_node_overview_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_recipe_node_overview_with_http_info(
            data_set_id,
            transformation_graph_version_number,
            data_set_node_id,
            analysis_type,
            **kwargs,
        )

    @validate_arguments
    def get_recipe_node_overview_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        analysis_type: Annotated[
            Optional[StrictStr], Field(description="Preferred analysis type")
        ] = None,
        **kwargs,
    ) -> ApiResponse:
        """Retrieves schema overview statistics of a recipe node execution result. Returns NOT_FOUND if the data set, transformation graph, node, or schema overview does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param analysis_type: Preferred analysis type
        :type analysis_type: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
            "analysis_type",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipe_node_overview" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        # process the query parameters
        _query_params = []
        if _params.get("analysis_type") is not None:
            _query_params.append(("analysisType", _params["analysis_type"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "Dict[str, object]",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}/overview",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_recipe_node_schema_alerts(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        analysis_type: Annotated[
            Optional[StrictStr], Field(description="Preferred analysis type")
        ] = None,
        **kwargs,
    ) -> List[Dict[str, object]]:
        """Retrieves schema alerts of a recipe node execution result. Returns NOT_FOUND if the data set, transformation graph, node, column, or schema alerts does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param analysis_type: Preferred analysis type
        :type analysis_type: str
        :return: Returns the result object.
        :rtype: List[Dict[str, object]]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_recipe_node_schema_alerts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_recipe_node_schema_alerts_with_http_info(
            data_set_id,
            transformation_graph_version_number,
            data_set_node_id,
            analysis_type,
            **kwargs,
        )

    @validate_arguments
    def get_recipe_node_schema_alerts_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        analysis_type: Annotated[
            Optional[StrictStr], Field(description="Preferred analysis type")
        ] = None,
        **kwargs,
    ) -> ApiResponse:
        """Retrieves schema alerts of a recipe node execution result. Returns NOT_FOUND if the data set, transformation graph, node, column, or schema alerts does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param analysis_type: Preferred analysis type
        :type analysis_type: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[Dict[str, object]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
            "analysis_type",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipe_node_schema_alerts" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        # process the query parameters
        _query_params = []
        if _params.get("analysis_type") is not None:
            _query_params.append(("analysisType", _params["analysis_type"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[Dict[str, object]]",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}/schema-alerts",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_recipe_node_schema_analysis_status(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        analysis_type: Annotated[
            Optional[StrictStr], Field(description="Preferred analysis type")
        ] = None,
        **kwargs,
    ) -> SchemaAnalysisStatusResponse:
        """Retrieves schema analysis job status for a recipe node execution result. Returns NOT_FOUND if the data set, transformation graph, node, column, or schema analysis does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param analysis_type: Preferred analysis type
        :type analysis_type: str
        :return: Returns the result object.
        :rtype: SchemaAnalysisStatusResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_recipe_node_schema_analysis_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_recipe_node_schema_analysis_status_with_http_info(
            data_set_id,
            transformation_graph_version_number,
            data_set_node_id,
            analysis_type,
            **kwargs,
        )

    @validate_arguments
    def get_recipe_node_schema_analysis_status_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        analysis_type: Annotated[
            Optional[StrictStr], Field(description="Preferred analysis type")
        ] = None,
        **kwargs,
    ) -> ApiResponse:
        """Retrieves schema analysis job status for a recipe node execution result. Returns NOT_FOUND if the data set, transformation graph, node, column, or schema analysis does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param analysis_type: Preferred analysis type
        :type analysis_type: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(SchemaAnalysisStatusResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
            "analysis_type",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipe_node_schema_analysis_status" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        # process the query parameters
        _query_params = []
        if _params.get("analysis_type") is not None:
            _query_params.append(("analysisType", _params["analysis_type"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "SchemaAnalysisStatusResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}/schema-analysis-status",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_transformation_graph_by_version(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        **kwargs,
    ) -> TransformationGraphWrapperResponse:
        """Retrieves detailed information about a specific transformation graph version including its nodes, edges, and configuration. Returns NOT_FOUND if the DataSet or version does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :return: Returns the result object.
        :rtype: TransformationGraphWrapperResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_transformation_graph_by_version_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_transformation_graph_by_version_with_http_info(
            data_set_id, transformation_graph_version_number, **kwargs
        )

    @validate_arguments
    def get_transformation_graph_by_version_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves detailed information about a specific transformation graph version including its nodes, edges, and configuration. Returns NOT_FOUND if the DataSet or version does not exist.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(TransformationGraphWrapperResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_set_id", "transformation_graph_version_number"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transformation_graph_by_version" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "TransformationGraphWrapperResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def is_data_set_name_available(
        self,
        name: Annotated[
            StrictStr,
            Field(
                ...,
                description="The proposed name for the DataSet to check for availability",
            ),
        ],
        **kwargs,
    ) -> bool:
        """Validates whether a DataSet name is available for use within the current workspace. Returns true if the name can be used for creating a new DataSet, false if it already exists.

        :param name: The proposed name for the DataSet to check for availability (required)
        :type name: str
        :return: Returns the result object.
        :rtype: bool
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the is_data_set_name_available_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.is_data_set_name_available_with_http_info(name, **kwargs)

    @validate_arguments
    def is_data_set_name_available_with_http_info(
        self,
        name: Annotated[
            StrictStr,
            Field(
                ...,
                description="The proposed name for the DataSet to check for availability",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Validates whether a DataSet name is available for use within the current workspace. Returns true if the name can be used for creating a new DataSet, false if it already exists.

        :param name: The proposed name for the DataSet to check for availability (required)
        :type name: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(bool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method is_data_set_name_available" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["name"] is not None:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "bool",
        }

        return self.api_client.call_api(
            "/v1/data-set-utils/is-name-available/{name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def is_recipe_node_name_available(
        self,
        name: Annotated[
            StrictStr,
            Field(
                ...,
                description="The proposed name for the recipe node to check for availability",
            ),
        ],
        data_set_data_table_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="The unique identifier of the DataTable node within the DataSet transformation graph context",
            ),
        ],
        **kwargs,
    ) -> bool:
        """Validates whether a recipe node name is available for use within the specified DataSet context. This ensures that recipe names remain unique within the transformation graph scope. Returns true if the name can be used for creating a new recipe node, false if it already exists.

        :param name: The proposed name for the recipe node to check for availability (required)
        :type name: str
        :param data_set_data_table_id: The unique identifier of the DataTable node within the DataSet transformation graph context (required)
        :type data_set_data_table_id: int
        :return: Returns the result object.
        :rtype: bool
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the is_recipe_node_name_available_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.is_recipe_node_name_available_with_http_info(
            name, data_set_data_table_id, **kwargs
        )

    @validate_arguments
    def is_recipe_node_name_available_with_http_info(
        self,
        name: Annotated[
            StrictStr,
            Field(
                ...,
                description="The proposed name for the recipe node to check for availability",
            ),
        ],
        data_set_data_table_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="The unique identifier of the DataTable node within the DataSet transformation graph context",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Validates whether a recipe node name is available for use within the specified DataSet context. This ensures that recipe names remain unique within the transformation graph scope. Returns true if the name can be used for creating a new recipe node, false if it already exists.

        :param name: The proposed name for the recipe node to check for availability (required)
        :type name: str
        :param data_set_data_table_id: The unique identifier of the DataTable node within the DataSet transformation graph context (required)
        :type data_set_data_table_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(bool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["name", "data_set_data_table_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method is_recipe_node_name_available" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["name"] is not None:
            _path_params["name"] = _params["name"]

        if _params["data_set_data_table_id"] is not None:
            _path_params["data-set-data-table-id"] = _params["data_set_data_table_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "bool",
        }

        return self.api_client.call_api(
            "/v1/recipe-utils/is-name-available/{name}/{data-set-data-table-id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_data_sets(self, **kwargs) -> List[DataSetResponse]:
        """Retrieves a list of all DataSets. DataSets represent complex data transformation workflows that combine multiple DataTables and recipes to produce processed datasets through transformation graphs.
        :return: Returns the result object.
        :rtype: List[DataSetResponse]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_data_sets_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_data_sets_with_http_info(**kwargs)

    @validate_arguments
    def list_data_sets_with_http_info(self, **kwargs) -> ApiResponse:
        """Retrieves a list of all DataSets. DataSets represent complex data transformation workflows that combine multiple DataTables and recipes to produce processed datasets through transformation graphs.
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[DataSetResponse], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_sets" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[DataSetResponse]",
        }

        return self.api_client.call_api(
            "/v1/data-sets",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_transformation_graphs(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        **kwargs,
    ) -> List[LeanTransformationGraphResponse]:
        """Retrieves all transformation graph versions for the specified DataSet. Each version represents a different configuration of the data transformation workflow.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :return: Returns the result object.
        :rtype: List[LeanTransformationGraphResponse]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_transformation_graphs_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_transformation_graphs_with_http_info(data_set_id, **kwargs)

    @validate_arguments
    def list_transformation_graphs_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves all transformation graph versions for the specified DataSet. Each version represents a different configuration of the data transformation workflow.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[LeanTransformationGraphResponse], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_set_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transformation_graphs" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[LeanTransformationGraphResponse]",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def release_transformaion_graph(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        **kwargs,
    ) -> TransformationGraphWrapperResponse:
        """Marks the transformation graph as released for production use. This operation validates that all leaf recipe nodes have successfully executed on the complete dataset (not sample data) before allowing the release. Table nodes without edges are skipped during validation.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :return: Returns the result object.
        :rtype: TransformationGraphWrapperResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the release_transformaion_graph_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.release_transformaion_graph_with_http_info(
            data_set_id, transformation_graph_version_number, **kwargs
        )

    @validate_arguments
    def release_transformaion_graph_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Marks the transformation graph as released for production use. This operation validates that all leaf recipe nodes have successfully executed on the complete dataset (not sample data) before allowing the release. Table nodes without edges are skipped during validation.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(TransformationGraphWrapperResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_set_id", "transformation_graph_version_number"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method release_transformaion_graph" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "TransformationGraphWrapperResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/release",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def stop_recipe_execution(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> None:
        """stops the execution of a recipe node that is currently running. This operation allows you to cancel long-running or stuck recipe executions. It will not delete the node or its configuration, but will stop any ongoing processing.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the stop_recipe_execution_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.stop_recipe_execution_with_http_info(
            data_set_id, transformation_graph_version_number, data_set_node_id, **kwargs
        )

    @validate_arguments
    def stop_recipe_execution_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """stops the execution of a recipe node that is currently running. This operation allows you to cancel long-running or stuck recipe executions. It will not delete the node or its configuration, but will stop any ongoing processing.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_recipe_execution" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}/execute",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def update_data_set(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        update_data_set_request: Annotated[
            UpdateDataSetRequest,
            Field(
                ...,
                description="Request body containing the updated configuration for an existing DataSet, including metadata changes such as name, description, and tags",
            ),
        ],
        **kwargs,
    ) -> DataSetResponse:
        """Updates the metadata of an existing DataSet such as name, description, and tags. This operation does not modify the transformation graph structure - use specific transformation graph operations for that purpose.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param update_data_set_request: Request body containing the updated configuration for an existing DataSet, including metadata changes such as name, description, and tags (required)
        :type update_data_set_request: UpdateDataSetRequest
        :return: Returns the result object.
        :rtype: DataSetResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the update_data_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.update_data_set_with_http_info(
            data_set_id, update_data_set_request, **kwargs
        )

    @validate_arguments
    def update_data_set_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        update_data_set_request: Annotated[
            UpdateDataSetRequest,
            Field(
                ...,
                description="Request body containing the updated configuration for an existing DataSet, including metadata changes such as name, description, and tags",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Updates the metadata of an existing DataSet such as name, description, and tags. This operation does not modify the transformation graph structure - use specific transformation graph operations for that purpose.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param update_data_set_request: Request body containing the updated configuration for an existing DataSet, including metadata changes such as name, description, and tags (required)
        :type update_data_set_request: UpdateDataSetRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataSetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_set_id", "update_data_set_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_set" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["update_data_set_request"] is not None:
            _body_params = _params["update_data_set_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataSetResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def update_data_set_node_in_transformation_graph(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        update_data_set_node_request: Annotated[
            UpdateDataSetNodeRequest,
            Field(
                ...,
                description="Request body containing the updated configuration for an existing recipe node within a transformation graph. Only recipe nodes can be updated through this endpoint",
            ),
        ],
        **kwargs,
    ) -> DataSetNodeResponse:
        """Updates the configuration of an existing node (recipe or dataTable) within the specified transformation graph version.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param update_data_set_node_request: Request body containing the updated configuration for an existing recipe node within a transformation graph. Only recipe nodes can be updated through this endpoint (required)
        :type update_data_set_node_request: UpdateDataSetNodeRequest
        :return: Returns the result object.
        :rtype: DataSetNodeResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the update_data_set_node_in_transformation_graph_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.update_data_set_node_in_transformation_graph_with_http_info(
            data_set_id,
            transformation_graph_version_number,
            data_set_node_id,
            update_data_set_node_request,
            **kwargs,
        )

    @validate_arguments
    def update_data_set_node_in_transformation_graph_with_http_info(
        self,
        data_set_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSet to operate on"),
        ],
        transformation_graph_version_number: Annotated[
            StrictInt,
            Field(
                ...,
                description="Version number of the transformation graph within the DataSet",
            ),
        ],
        data_set_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        update_data_set_node_request: Annotated[
            UpdateDataSetNodeRequest,
            Field(
                ...,
                description="Request body containing the updated configuration for an existing recipe node within a transformation graph. Only recipe nodes can be updated through this endpoint",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Updates the configuration of an existing node (recipe or dataTable) within the specified transformation graph version.

        :param data_set_id: Unique identifier of the DataSet to operate on (required)
        :type data_set_id: int
        :param transformation_graph_version_number: Version number of the transformation graph within the DataSet (required)
        :type transformation_graph_version_number: int
        :param data_set_node_id: Unique identifier of the node within the transformation graph (required)
        :type data_set_node_id: int
        :param update_data_set_node_request: Request body containing the updated configuration for an existing recipe node within a transformation graph. Only recipe nodes can be updated through this endpoint (required)
        :type update_data_set_node_request: UpdateDataSetNodeRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataSetNodeResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "data_set_id",
            "transformation_graph_version_number",
            "data_set_node_id",
            "update_data_set_node_request",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_set_node_in_transformation_graph" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_set_id"] is not None:
            _path_params["data-set-id"] = _params["data_set_id"]

        if _params["transformation_graph_version_number"] is not None:
            _path_params["transformation-graph-version-number"] = _params[
                "transformation_graph_version_number"
            ]

        if _params["data_set_node_id"] is not None:
            _path_params["data-set-node-id"] = _params["data_set_node_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["update_data_set_node_request"] is not None:
            _body_params = _params["update_data_set_node_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataSetNodeResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sets/{data-set-id}/transformation-graphs/{transformation-graph-version-number}/nodes/{data-set-node-id}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
