# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from pydantic.v1 import Field, StrictStr, validate_arguments
from typing_extensions import Annotated

from earnix_elevate.clients.data.api_client import ApiClient
from earnix_elevate.clients.data.api_response import ApiResponse
from earnix_elevate.clients.data.exceptions import ApiTypeError
from earnix_elevate.clients.data.models.export_s3_job_status_response import (
    ExportS3JobStatusResponse,
)


class ExportJobServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_export_s3_job_status(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="Unique identifier of the background job to query"),
        ],
        **kwargs,
    ) -> ExportS3JobStatusResponse:
        """Retrieves the current status and progress information of an Amazon S3 export job. Use this endpoint to monitor long-running export operations and determine when they have completed successfully or failed. The response includes detailed status information, progress indicators, and any error details if the job failed.

        :param job_id: Unique identifier of the background job to query (required)
        :type job_id: str
        :return: Returns the result object.
        :rtype: ExportS3JobStatusResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_export_s3_job_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_export_s3_job_status_with_http_info(job_id, **kwargs)

    @validate_arguments
    def get_export_s3_job_status_with_http_info(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="Unique identifier of the background job to query"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves the current status and progress information of an Amazon S3 export job. Use this endpoint to monitor long-running export operations and determine when they have completed successfully or failed. The response includes detailed status information, progress indicators, and any error details if the job failed.

        :param job_id: Unique identifier of the background job to query (required)
        :type job_id: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ExportS3JobStatusResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_export_s3_job_status" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["job_id"] is not None:
            _path_params["job-id"] = _params["job_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ExportS3JobStatusResponse",
        }

        return self.api_client.call_api(
            "/v1/jobs/export-s3/{job-id}/status",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
