# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from datetime import datetime
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictStr


class ConversationResponse(BaseModel):
    """
    `ConversationResponse`

    Represents a conversation in the AI assistant service, containing metadata and a list of messages
    """

    conversation_id: Optional[StrictStr] = Field(
        default=None,
        alias="conversationId",
        description="Unique identifier for the conversation",
    )
    created_date: Optional[datetime] = Field(
        default=None,
        alias="createdDate",
        description="Date and time when the conversation was created",
    )
    last_modified_date: Optional[datetime] = Field(
        default=None,
        alias="lastModifiedDate",
        description="Date and time when the conversation was last modified",
    )
    __properties = ["conversationId", "createdDate", "lastModifiedDate"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ConversationResponse:
        """Create an instance of ConversationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ConversationResponse:
        """Create an instance of ConversationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ConversationResponse.parse_obj(obj)

        _obj = ConversationResponse.parse_obj(
            {
                "conversation_id": obj.get("conversationId"),
                "created_date": obj.get("createdDate"),
                "last_modified_date": obj.get("lastModifiedDate"),
            }
        )
        return _obj
