# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from importlib import import_module
from typing import TYPE_CHECKING, Optional, Union

from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist, constr

if TYPE_CHECKING:
    from earnix_elevate.clients.data.models.data_set_data_table_node_response import (
        DataSetDataTableNodeResponse,
    )
    from earnix_elevate.clients.data.models.data_set_recipe_node_response import (
        DataSetRecipeNodeResponse,
    )


class DataSetNodeResponse(BaseModel):
    """
    `DataSetNodeResponse`
    """

    node_type: Optional[StrictStr] = Field(
        default=None,
        alias="nodeType",
        description="Type of node in the transformation graph (TABLE for DataTable references, RECIPE for transformation logic)",
    )
    name: Optional[constr(strict=True, max_length=100, min_length=3)] = Field(
        default=None,
        description="Name of the entity for identification and display purposes",
    )
    description: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        description="Optional detailed description providing additional context about the entity",
    )
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(
        default=None,
        description="List of unique tags for categorizing and organizing the entity",
    )
    id: StrictInt = Field(default=..., description="Unique identifier of the entity")
    lock_version: Optional[StrictInt] = Field(
        default=None,
        alias="lockVersion",
        description="Version number used for optimistic locking to prevent concurrent modifications",
    )
    __properties = ["name", "description", "tags", "id", "lockVersion"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = "nodeType"

    # discriminator mappings
    __discriminator_value_class_map = {
        "RECIPE": "DataSetRecipeNodeResponse",
        "TABLE": "DataSetDataTableNodeResponse",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[DataSetDataTableNodeResponse, DataSetRecipeNodeResponse]:
        """Create an instance of DataSetNodeResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[DataSetDataTableNodeResponse, DataSetRecipeNodeResponse]:
        """Create an instance of DataSetNodeResponse from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "DataSetRecipeNodeResponse":
            return import_module(
                "earnix_elevate.clients.data.models.data_set_recipe_node_response"
            ).DataSetRecipeNodeResponse.from_dict(obj)
        if object_type == "DataSetDataTableNodeResponse":
            return import_module(
                "earnix_elevate.clients.data.models.data_set_data_table_node_response"
            ).DataSetDataTableNodeResponse.from_dict(obj)
        raise ValueError(
            "DataSetNodeResponse failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
