# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from datetime import datetime
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist, constr

from earnix_elevate.clients.data.models.lean_transformation_graph_response import (
    LeanTransformationGraphResponse,
)
from earnix_elevate.clients.data.models.user_response import UserResponse


class DataSetResponse(BaseModel):
    """
    `DataSetResponse`

    Represents a DataSet which is a complex data transformation workflow that combines multiple DataTables and recipes through a transformation graph to produce processed datasets. DataSets support versioning to track different configurations
    """

    latest_transformation_graph: Optional[LeanTransformationGraphResponse] = Field(
        default=None, alias="latestTransformationGraph"
    )
    name: Optional[constr(strict=True, max_length=100, min_length=3)] = Field(
        default=None,
        description="Name of the entity for identification and display purposes",
    )
    description: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        description="Optional detailed description providing additional context about the entity",
    )
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(
        default=None,
        description="List of unique tags for categorizing and organizing the entity",
    )
    id: Optional[StrictInt] = Field(
        default=None, description="Unique identifier of the entity"
    )
    lock_version: Optional[StrictInt] = Field(
        default=None,
        alias="lockVersion",
        description="Version number used for optimistic locking to prevent concurrent modifications",
    )
    created_by: Optional[UserResponse] = Field(default=None, alias="createdBy")
    created_date: Optional[datetime] = Field(
        default=None,
        alias="createdDate",
        description="Date and time when this entity was created",
    )
    last_modified_by: Optional[UserResponse] = Field(
        default=None, alias="lastModifiedBy"
    )
    last_modified_date: Optional[datetime] = Field(
        default=None,
        alias="lastModifiedDate",
        description="Date and time when this entity was last modified",
    )
    __properties = [
        "name",
        "description",
        "tags",
        "id",
        "lockVersion",
        "createdBy",
        "createdDate",
        "lastModifiedBy",
        "lastModifiedDate",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataSetResponse:
        """Create an instance of DataSetResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict["createdBy"] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict["lastModifiedBy"] = self.last_modified_by.to_dict()
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataSetResponse:
        """Create an instance of DataSetResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DataSetResponse.parse_obj(obj)

        _obj = DataSetResponse.parse_obj(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "created_by": UserResponse.from_dict(obj.get("createdBy"))
                if obj.get("createdBy") is not None
                else None,
                "created_date": obj.get("createdDate"),
                "last_modified_by": UserResponse.from_dict(obj.get("lastModifiedBy"))
                if obj.get("lastModifiedBy") is not None
                else None,
                "last_modified_date": obj.get("lastModifiedDate"),
            }
        )
        return _obj
