# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from importlib import import_module
from typing import TYPE_CHECKING, Union

from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, validator

if TYPE_CHECKING:
    from earnix_elevate.clients.data.models.update_data_set_data_table_node_request import (
        UpdateDataSetDataTableNodeRequest,
    )
    from earnix_elevate.clients.data.models.update_data_set_recipe_node_request import (
        UpdateDataSetRecipeNodeRequest,
    )


class UpdateDataSetNodeRequest(BaseModel):
    """
    `UpdateDataSetNodeRequest`
    """

    node_type: StrictStr = Field(
        default=...,
        alias="nodeType",
        description="Type of node in the transformation graph (TABLE for DataTable references, RECIPE for transformation logic)",
    )
    data_set_id: StrictInt = Field(
        default=...,
        alias="dataSetId",
        description="Unique identifier of the DataSet that contains this node",
    )
    __properties = ["nodeType", "dataSetId"]

    @validator("node_type")
    def node_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in (
            "TABLE",
            "RECIPE",
        ):
            raise ValueError("must be one of enum values ('TABLE', 'RECIPE')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = "nodeType"

    # discriminator mappings
    __discriminator_value_class_map = {
        "RECIPE": "UpdateDataSetRecipeNodeRequest",
        "TABLE": "UpdateDataSetDataTableNodeRequest",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[UpdateDataSetDataTableNodeRequest, UpdateDataSetRecipeNodeRequest]:
        """Create an instance of UpdateDataSetNodeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[UpdateDataSetDataTableNodeRequest, UpdateDataSetRecipeNodeRequest]:
        """Create an instance of UpdateDataSetNodeRequest from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "UpdateDataSetRecipeNodeRequest":
            return import_module(
                "earnix_elevate.clients.data.models.update_data_set_recipe_node_request"
            ).UpdateDataSetRecipeNodeRequest.from_dict(obj)
        if object_type == "UpdateDataSetDataTableNodeRequest":
            return import_module(
                "earnix_elevate.clients.data.models.update_data_set_data_table_node_request"
            ).UpdateDataSetDataTableNodeRequest.from_dict(obj)
        raise ValueError(
            "UpdateDataSetNodeRequest failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
