# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from typing import List, Optional

from pydantic.v1 import Field, StrictInt, StrictStr, conint, validate_arguments
from typing_extensions import Annotated

from earnix_elevate.clients.imx.api_client import ApiClient
from earnix_elevate.clients.imx.api_response import ApiResponse
from earnix_elevate.clients.imx.exceptions import ApiTypeError
from earnix_elevate.clients.imx.models.browse_bucket_data_source_request import (
    BrowseBucketDataSourceRequest,
)
from earnix_elevate.clients.imx.models.browse_bucket_data_source_response import (
    BrowseBucketDataSourceResponse,
)
from earnix_elevate.clients.imx.models.connection_response import ConnectionResponse
from earnix_elevate.clients.imx.models.create_connection_request import (
    CreateConnectionRequest,
)
from earnix_elevate.clients.imx.models.merge_connection_request import (
    MergeConnectionRequest,
)
from earnix_elevate.clients.imx.models.table_details_response import (
    TableDetailsResponse,
)
from earnix_elevate.clients.imx.models.test_connection_request import (
    TestConnectionRequest,
)
from earnix_elevate.clients.imx.models.test_rdbms_data_source_request import (
    TestRDBMSDataSourceRequest,
)
from earnix_elevate.clients.imx.models.test_updated_connection_request import (
    TestUpdatedConnectionRequest,
)
from earnix_elevate.clients.imx.models.update_connection_request import (
    UpdateConnectionRequest,
)


class ConnectionServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def browse_bucket_data_source(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        browse_bucket_data_source_request: Annotated[
            BrowseBucketDataSourceRequest,
            Field(..., description="Browse Bucket DataSource Request"),
        ],
        browse_limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="Maximum number of objects to retrieve in the browse operation"
            ),
        ] = None,
        **kwargs,
    ) -> BrowseBucketDataSourceResponse:
        """Browses the contents of a bucket DataSource at the specified path, returning a list of available files and folders. This helps users explore the data structure before configuring DataSources.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param browse_bucket_data_source_request: Browse Bucket DataSource Request (required)
        :type browse_bucket_data_source_request: BrowseBucketDataSourceRequest
        :param browse_limit: Maximum number of objects to retrieve in the browse operation
        :type browse_limit: int
        :return: Returns the result object.
        :rtype: BrowseBucketDataSourceResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the browse_bucket_data_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.browse_bucket_data_source_with_http_info(
            connection_id, browse_bucket_data_source_request, browse_limit, **kwargs
        )

    @validate_arguments
    def browse_bucket_data_source_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        browse_bucket_data_source_request: Annotated[
            BrowseBucketDataSourceRequest,
            Field(..., description="Browse Bucket DataSource Request"),
        ],
        browse_limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="Maximum number of objects to retrieve in the browse operation"
            ),
        ] = None,
        **kwargs,
    ) -> ApiResponse:
        """Browses the contents of a bucket DataSource at the specified path, returning a list of available files and folders. This helps users explore the data structure before configuring DataSources.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param browse_bucket_data_source_request: Browse Bucket DataSource Request (required)
        :type browse_bucket_data_source_request: BrowseBucketDataSourceRequest
        :param browse_limit: Maximum number of objects to retrieve in the browse operation
        :type browse_limit: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(BrowseBucketDataSourceResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "connection_id",
            "browse_bucket_data_source_request",
            "browse_limit",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method browse_bucket_data_source" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        # process the query parameters
        _query_params = []
        if _params.get("browse_limit") is not None:
            _query_params.append(("browse-limit", _params["browse_limit"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["browse_bucket_data_source_request"] is not None:
            _body_params = _params["browse_bucket_data_source_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "BrowseBucketDataSourceResponse",
        }

        return self.api_client.call_api(
            "/v1/connections/{connection-id}/browse-bucket-data-source",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def create_connection(
        self,
        create_connection_request: Annotated[
            CreateConnectionRequest, Field(..., description="Create Connection Request")
        ],
        **kwargs,
    ) -> ConnectionResponse:
        """Creates a new Connection that defines how to authenticate and connect to an external data system. Each Connection type has specific authentication requirements and configuration parameters.

        :param create_connection_request: Create Connection Request (required)
        :type create_connection_request: CreateConnectionRequest
        :return: Returns the result object.
        :rtype: ConnectionResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the create_connection_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.create_connection_with_http_info(
            create_connection_request, **kwargs
        )

    @validate_arguments
    def create_connection_with_http_info(
        self,
        create_connection_request: Annotated[
            CreateConnectionRequest, Field(..., description="Create Connection Request")
        ],
        **kwargs,
    ) -> ApiResponse:
        """Creates a new Connection that defines how to authenticate and connect to an external data system. Each Connection type has specific authentication requirements and configuration parameters.

        :param create_connection_request: Create Connection Request (required)
        :type create_connection_request: CreateConnectionRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ConnectionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["create_connection_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_connection" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["create_connection_request"] is not None:
            _body_params = _params["create_connection_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ConnectionResponse",
        }

        return self.api_client.call_api(
            "/v1/connections",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_connection(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        **kwargs,
    ) -> None:
        """Removes a Connection from your workspace. This operation will fail if there are DataSources currently using this Connection. Returns NOT_FOUND if the Connection does not exist.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_connection_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.delete_connection_with_http_info(connection_id, **kwargs)

    @validate_arguments
    def delete_connection_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Removes a Connection from your workspace. This operation will fail if there are DataSources currently using this Connection. Returns NOT_FOUND if the Connection does not exist.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["connection_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_connection" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/connections/{connection-id}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_connection(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        **kwargs,
    ) -> ConnectionResponse:
        """Retrieves detailed information about a specific Connection including its configuration, authentication details, and metadata. Returns NOT_FOUND if the Connection does not exist.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :return: Returns the result object.
        :rtype: ConnectionResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_connection_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_connection_with_http_info(connection_id, **kwargs)

    @validate_arguments
    def get_connection_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves detailed information about a specific Connection including its configuration, authentication details, and metadata. Returns NOT_FOUND if the Connection does not exist.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ConnectionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["connection_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connection" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ConnectionResponse",
        }

        return self.api_client.call_api(
            "/v1/connections/{connection-id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def is_connection_name_available(
        self,
        name: Annotated[
            StrictStr,
            Field(
                ...,
                description="The proposed name for the Connection to check for availability (case-insensitive)",
            ),
        ],
        **kwargs,
    ) -> bool:
        """Validates whether a Connection name is available for use within the current workspace. Name validation is case-insensitive. Returns true if the name can be used for creating a new Connection, false if it already exists.

        :param name: The proposed name for the Connection to check for availability (case-insensitive) (required)
        :type name: str
        :return: Returns the result object.
        :rtype: bool
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the is_connection_name_available_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.is_connection_name_available_with_http_info(name, **kwargs)

    @validate_arguments
    def is_connection_name_available_with_http_info(
        self,
        name: Annotated[
            StrictStr,
            Field(
                ...,
                description="The proposed name for the Connection to check for availability (case-insensitive)",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Validates whether a Connection name is available for use within the current workspace. Name validation is case-insensitive. Returns true if the name can be used for creating a new Connection, false if it already exists.

        :param name: The proposed name for the Connection to check for availability (case-insensitive) (required)
        :type name: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(bool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method is_connection_name_available" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["name"] is not None:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "bool",
        }

        return self.api_client.call_api(
            "/v1/connection-utils/is-name-available/{name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_connections(self, **kwargs) -> List[ConnectionResponse]:
        """Retrieves a list of all Connections. Connections represent the authentication and configuration details needed to connect to external data systems such as databases, cloud storage services, or data platforms.
        :return: Returns the result object.
        :rtype: List[ConnectionResponse]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_connections_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_connections_with_http_info(**kwargs)

    @validate_arguments
    def list_connections_with_http_info(self, **kwargs) -> ApiResponse:
        """Retrieves a list of all Connections. Connections represent the authentication and configuration details needed to connect to external data systems such as databases, cloud storage services, or data platforms.
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[ConnectionResponse], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_connections" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[ConnectionResponse]",
        }

        return self.api_client.call_api(
            "/v1/connections",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_deltasharing_schema_tables(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        share: Annotated[
            StrictStr, Field(..., description="The name of the Deltasharing Share")
        ],
        var_schema: Annotated[
            StrictStr,
            Field(
                ..., description="The name of the schema within the Deltasharing Share"
            ),
        ],
        **kwargs,
    ) -> List[str]:
        """Retrieves a list of all available tables in the specified schema for a given share of a Deltasharing connection.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param share: The name of the Deltasharing Share (required)
        :type share: str
        :param var_schema: The name of the schema within the Deltasharing Share (required)
        :type var_schema: str
        :return: Returns the result object.
        :rtype: List[str]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_deltasharing_schema_tables_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_deltasharing_schema_tables_with_http_info(
            connection_id, share, var_schema, **kwargs
        )

    @validate_arguments
    def list_deltasharing_schema_tables_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        share: Annotated[
            StrictStr, Field(..., description="The name of the Deltasharing Share")
        ],
        var_schema: Annotated[
            StrictStr,
            Field(
                ..., description="The name of the schema within the Deltasharing Share"
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves a list of all available tables in the specified schema for a given share of a Deltasharing connection.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param share: The name of the Deltasharing Share (required)
        :type share: str
        :param var_schema: The name of the schema within the Deltasharing Share (required)
        :type var_schema: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["connection_id", "share", "var_schema"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_deltasharing_schema_tables" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        if _params["share"] is not None:
            _path_params["share"] = _params["share"]

        if _params["var_schema"] is not None:
            _path_params["schema"] = _params["var_schema"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[str]",
        }

        return self.api_client.call_api(
            "/v1/connections/{connection-id}/deltasharing/{share}/schemas/{schema}/tables",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_deltasharing_schemas(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        share: Annotated[
            StrictStr, Field(..., description="The name of the Deltasharing Share")
        ],
        **kwargs,
    ) -> List[str]:
        """Retrieves a list of all available schemas within the specified share of a Deltasharing connection.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param share: The name of the Deltasharing Share (required)
        :type share: str
        :return: Returns the result object.
        :rtype: List[str]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_deltasharing_schemas_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_deltasharing_schemas_with_http_info(
            connection_id, share, **kwargs
        )

    @validate_arguments
    def list_deltasharing_schemas_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        share: Annotated[
            StrictStr, Field(..., description="The name of the Deltasharing Share")
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves a list of all available schemas within the specified share of a Deltasharing connection.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param share: The name of the Deltasharing Share (required)
        :type share: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["connection_id", "share"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_deltasharing_schemas" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        if _params["share"] is not None:
            _path_params["share"] = _params["share"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[str]",
        }

        return self.api_client.call_api(
            "/v1/connections/{connection-id}/deltasharing/{share}/schemas",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_deltasharing_shares(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        **kwargs,
    ) -> List[str]:
        """Retrieves a list of all available Shares in the specified Deltasharing connection.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :return: Returns the result object.
        :rtype: List[str]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_deltasharing_shares_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_deltasharing_shares_with_http_info(connection_id, **kwargs)

    @validate_arguments
    def list_deltasharing_shares_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves a list of all available Shares in the specified Deltasharing connection.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["connection_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_deltasharing_shares" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[str]",
        }

        return self.api_client.call_api(
            "/v1/connections/{connection-id}/deltasharing",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_tables(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        **kwargs,
    ) -> List[TableDetailsResponse]:
        """Retrieves a list of all accessible tables and views in the specified connection. Returns table metadata including database (shares in case of delasharing), schema, and table names for browsing available data sources.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :return: Returns the result object.
        :rtype: List[TableDetailsResponse]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_tables_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_tables_with_http_info(connection_id, **kwargs)

    @validate_arguments
    def list_tables_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves a list of all accessible tables and views in the specified connection. Returns table metadata including database (shares in case of delasharing), schema, and table names for browsing available data sources.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[TableDetailsResponse], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["connection_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tables" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[TableDetailsResponse]",
        }

        return self.api_client.call_api(
            "/v1/connections/{connection-id}/tables",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_warehouses(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        **kwargs,
    ) -> List[str]:
        """Retrieves a list of all available warehouses in a Snowflake connection. Warehouses are compute resources that can be used for query execution and data processing operations.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :return: Returns the result object.
        :rtype: List[str]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_warehouses_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_warehouses_with_http_info(connection_id, **kwargs)

    @validate_arguments
    def list_warehouses_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves a list of all available warehouses in a Snowflake connection. Warehouses are compute resources that can be used for query execution and data processing operations.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["connection_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_warehouses" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[str]",
        }

        return self.api_client.call_api(
            "/v1/connections/{connection-id}/warehouses",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def merge_connection(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        merge_connection_request: Annotated[
            MergeConnectionRequest, Field(..., description="Merge Connection Request")
        ],
        **kwargs,
    ) -> ConnectionResponse:
        """Partially updates a Connection by applying only the provided fields while leaving other fields unchanged. This operation uses merge-patch semantics and requires the current lock version.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param merge_connection_request: Merge Connection Request (required)
        :type merge_connection_request: MergeConnectionRequest
        :return: Returns the result object.
        :rtype: ConnectionResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the merge_connection_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.merge_connection_with_http_info(
            connection_id, merge_connection_request, **kwargs
        )

    @validate_arguments
    def merge_connection_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        merge_connection_request: Annotated[
            MergeConnectionRequest, Field(..., description="Merge Connection Request")
        ],
        **kwargs,
    ) -> ApiResponse:
        """Partially updates a Connection by applying only the provided fields while leaving other fields unchanged. This operation uses merge-patch semantics and requires the current lock version.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param merge_connection_request: Merge Connection Request (required)
        :type merge_connection_request: MergeConnectionRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ConnectionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["connection_id", "merge_connection_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method merge_connection" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["merge_connection_request"] is not None:
            _body_params = _params["merge_connection_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(
                ["application/merge-patch+json"]
            ),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ConnectionResponse",
        }

        return self.api_client.call_api(
            "/v1/connections/{connection-id}",
            "PATCH",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def test_connection(
        self,
        test_connection_request: Annotated[
            TestConnectionRequest, Field(..., description="Test Connection Request")
        ],
        **kwargs,
    ) -> None:
        """Tests a Connection configuration by attempting to establish connectivity using the provided authentication details and connection parameters. This allows validation before creating the Connection.

        :param test_connection_request: Test Connection Request (required)
        :type test_connection_request: TestConnectionRequest
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the test_connection_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.test_connection_with_http_info(test_connection_request, **kwargs)

    @validate_arguments
    def test_connection_with_http_info(
        self,
        test_connection_request: Annotated[
            TestConnectionRequest, Field(..., description="Test Connection Request")
        ],
        **kwargs,
    ) -> ApiResponse:
        """Tests a Connection configuration by attempting to establish connectivity using the provided authentication details and connection parameters. This allows validation before creating the Connection.

        :param test_connection_request: Test Connection Request (required)
        :type test_connection_request: TestConnectionRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["test_connection_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_connection" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["test_connection_request"] is not None:
            _body_params = _params["test_connection_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/test-connection",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def test_connection_by_id(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        test_updated_connection_request: Annotated[
            Optional[TestUpdatedConnectionRequest],
            Field(
                description="Test Updated Connection Request - validates connectivity using current stored configuration with optional parameter overrides"
            ),
        ] = None,
        **kwargs,
    ) -> None:
        """Tests the connectivity of an existing Connection using its current configuration. Optionally accepts updated connection parameters to test connectivity before applying changes to the Connection.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param test_updated_connection_request: Test Updated Connection Request - validates connectivity using current stored configuration with optional parameter overrides
        :type test_updated_connection_request: TestUpdatedConnectionRequest
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the test_connection_by_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.test_connection_by_id_with_http_info(
            connection_id, test_updated_connection_request, **kwargs
        )

    @validate_arguments
    def test_connection_by_id_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        test_updated_connection_request: Annotated[
            Optional[TestUpdatedConnectionRequest],
            Field(
                description="Test Updated Connection Request - validates connectivity using current stored configuration with optional parameter overrides"
            ),
        ] = None,
        **kwargs,
    ) -> ApiResponse:
        """Tests the connectivity of an existing Connection using its current configuration. Optionally accepts updated connection parameters to test connectivity before applying changes to the Connection.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param test_updated_connection_request: Test Updated Connection Request - validates connectivity using current stored configuration with optional parameter overrides
        :type test_updated_connection_request: TestUpdatedConnectionRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["connection_id", "test_updated_connection_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_connection_by_id" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["test_updated_connection_request"] is not None:
            _body_params = _params["test_updated_connection_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/connections/{connection-id}/test-connection",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def test_rdbms_data_source(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        test_rdbms_data_source_request: Annotated[
            TestRDBMSDataSourceRequest,
            Field(..., description="Test RDBMS DataSource Request"),
        ],
        **kwargs,
    ) -> None:
        """Tests an RDBMS DataSource configuration by executing the specified query to verify data accessibility and query validity. This helps validate DataSource settings before creating or updating them.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param test_rdbms_data_source_request: Test RDBMS DataSource Request (required)
        :type test_rdbms_data_source_request: TestRDBMSDataSourceRequest
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the test_rdbms_data_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.test_rdbms_data_source_with_http_info(
            connection_id, test_rdbms_data_source_request, **kwargs
        )

    @validate_arguments
    def test_rdbms_data_source_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        test_rdbms_data_source_request: Annotated[
            TestRDBMSDataSourceRequest,
            Field(..., description="Test RDBMS DataSource Request"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Tests an RDBMS DataSource configuration by executing the specified query to verify data accessibility and query validity. This helps validate DataSource settings before creating or updating them.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param test_rdbms_data_source_request: Test RDBMS DataSource Request (required)
        :type test_rdbms_data_source_request: TestRDBMSDataSourceRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["connection_id", "test_rdbms_data_source_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_rdbms_data_source" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["test_rdbms_data_source_request"] is not None:
            _body_params = _params["test_rdbms_data_source_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/connections/{connection-id}/test-rdbms-data-source",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def update_connection(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        update_connection_request: Annotated[
            UpdateConnectionRequest, Field(..., description="Update Connection Request")
        ],
        **kwargs,
    ) -> ConnectionResponse:
        """Updates the complete configuration of an existing Connection including authentication details and connection parameters. The operation requires the current lock version to prevent concurrent modifications.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param update_connection_request: Update Connection Request (required)
        :type update_connection_request: UpdateConnectionRequest
        :return: Returns the result object.
        :rtype: ConnectionResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the update_connection_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.update_connection_with_http_info(
            connection_id, update_connection_request, **kwargs
        )

    @validate_arguments
    def update_connection_with_http_info(
        self,
        connection_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the Connection to operate on"),
        ],
        update_connection_request: Annotated[
            UpdateConnectionRequest, Field(..., description="Update Connection Request")
        ],
        **kwargs,
    ) -> ApiResponse:
        """Updates the complete configuration of an existing Connection including authentication details and connection parameters. The operation requires the current lock version to prevent concurrent modifications.

        :param connection_id: Unique identifier of the Connection to operate on (required)
        :type connection_id: int
        :param update_connection_request: Update Connection Request (required)
        :type update_connection_request: UpdateConnectionRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ConnectionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["connection_id", "update_connection_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_connection" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["connection_id"] is not None:
            _path_params["connection-id"] = _params["connection_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["update_connection_request"] is not None:
            _body_params = _params["update_connection_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ConnectionResponse",
        }

        return self.api_client.call_api(
            "/v1/connections/{connection-id}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
