# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from typing import List

from pydantic.v1 import Field, StrictInt, validate_arguments
from typing_extensions import Annotated

from earnix_elevate.clients.imx.api_client import ApiClient
from earnix_elevate.clients.imx.api_response import ApiResponse
from earnix_elevate.clients.imx.exceptions import ApiTypeError
from earnix_elevate.clients.imx.models.create_data_source_request import (
    CreateDataSourceRequest,
)
from earnix_elevate.clients.imx.models.data_source_response import DataSourceResponse
from earnix_elevate.clients.imx.models.update_data_source_request import (
    UpdateDataSourceRequest,
)


class DataSourceServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_data_source(
        self,
        create_data_source_request: Annotated[
            CreateDataSourceRequest, Field(..., description="Create DataSource Request")
        ],
        **kwargs,
    ) -> DataSourceResponse:
        """Creates a new DataSource that defines how to connect to and import data from an external system. The DataSource specifies the connection details and data location (query for databases, path for storage systems).

        :param create_data_source_request: Create DataSource Request (required)
        :type create_data_source_request: CreateDataSourceRequest
        :return: Returns the result object.
        :rtype: DataSourceResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the create_data_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.create_data_source_with_http_info(
            create_data_source_request, **kwargs
        )

    @validate_arguments
    def create_data_source_with_http_info(
        self,
        create_data_source_request: Annotated[
            CreateDataSourceRequest, Field(..., description="Create DataSource Request")
        ],
        **kwargs,
    ) -> ApiResponse:
        """Creates a new DataSource that defines how to connect to and import data from an external system. The DataSource specifies the connection details and data location (query for databases, path for storage systems).

        :param create_data_source_request: Create DataSource Request (required)
        :type create_data_source_request: CreateDataSourceRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataSourceResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["create_data_source_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_source" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["create_data_source_request"] is not None:
            _body_params = _params["create_data_source_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataSourceResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sources",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_data_source(
        self,
        data_source_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSource to operate on"),
        ],
        **kwargs,
    ) -> None:
        """Removes a DataSource from your workspace. This operation will fail if there are DataTables currently using this DataSource. Returns NOT_FOUND if the DataSource does not exist.

        :param data_source_id: Unique identifier of the DataSource to operate on (required)
        :type data_source_id: int
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_data_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.delete_data_source_with_http_info(data_source_id, **kwargs)

    @validate_arguments
    def delete_data_source_with_http_info(
        self,
        data_source_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSource to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Removes a DataSource from your workspace. This operation will fail if there are DataTables currently using this DataSource. Returns NOT_FOUND if the DataSource does not exist.

        :param data_source_id: Unique identifier of the DataSource to operate on (required)
        :type data_source_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["data_source_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_source" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_source_id"] is not None:
            _path_params["data-source-id"] = _params["data_source_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/data-sources/{data-source-id}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_data_source(
        self,
        data_source_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSource to operate on"),
        ],
        **kwargs,
    ) -> DataSourceResponse:
        """Retrieves detailed information about a specific DataSource including its connection configuration, data location settings, and metadata. Returns NOT_FOUND if the DataSource does not exist.

        :param data_source_id: Unique identifier of the DataSource to operate on (required)
        :type data_source_id: int
        :return: Returns the result object.
        :rtype: DataSourceResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_data_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_data_source_with_http_info(data_source_id, **kwargs)

    @validate_arguments
    def get_data_source_with_http_info(
        self,
        data_source_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSource to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves detailed information about a specific DataSource including its connection configuration, data location settings, and metadata. Returns NOT_FOUND if the DataSource does not exist.

        :param data_source_id: Unique identifier of the DataSource to operate on (required)
        :type data_source_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataSourceResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_source_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_source" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_source_id"] is not None:
            _path_params["data-source-id"] = _params["data_source_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataSourceResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sources/{data-source-id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_data_sources(self, **kwargs) -> List[DataSourceResponse]:
        """Retrieves a list of all DataSources. DataSources define the configuration for importing data from external systems such as databases, cloud storage, or data lakes into the platform.
        :return: Returns the result object.
        :rtype: List[DataSourceResponse]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_data_sources_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_data_sources_with_http_info(**kwargs)

    @validate_arguments
    def list_data_sources_with_http_info(self, **kwargs) -> ApiResponse:
        """Retrieves a list of all DataSources. DataSources define the configuration for importing data from external systems such as databases, cloud storage, or data lakes into the platform.
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[DataSourceResponse], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_sources" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[DataSourceResponse]",
        }

        return self.api_client.call_api(
            "/v1/data-sources",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def update_data_source(
        self,
        data_source_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSource to operate on"),
        ],
        update_data_source_request: Annotated[
            UpdateDataSourceRequest, Field(..., description="Update DataSource Request")
        ],
        **kwargs,
    ) -> DataSourceResponse:
        """Updates the configuration of an existing DataSource. This includes modifying connection settings, data location parameters, and metadata. The operation requires the current lock version to prevent concurrent modifications.

        :param data_source_id: Unique identifier of the DataSource to operate on (required)
        :type data_source_id: int
        :param update_data_source_request: Update DataSource Request (required)
        :type update_data_source_request: UpdateDataSourceRequest
        :return: Returns the result object.
        :rtype: DataSourceResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the update_data_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.update_data_source_with_http_info(
            data_source_id, update_data_source_request, **kwargs
        )

    @validate_arguments
    def update_data_source_with_http_info(
        self,
        data_source_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataSource to operate on"),
        ],
        update_data_source_request: Annotated[
            UpdateDataSourceRequest, Field(..., description="Update DataSource Request")
        ],
        **kwargs,
    ) -> ApiResponse:
        """Updates the configuration of an existing DataSource. This includes modifying connection settings, data location parameters, and metadata. The operation requires the current lock version to prevent concurrent modifications.

        :param data_source_id: Unique identifier of the DataSource to operate on (required)
        :type data_source_id: int
        :param update_data_source_request: Update DataSource Request (required)
        :type update_data_source_request: UpdateDataSourceRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataSourceResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_source_id", "update_data_source_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_source" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_source_id"] is not None:
            _path_params["data-source-id"] = _params["data_source_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["update_data_source_request"] is not None:
            _body_params = _params["update_data_source_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataSourceResponse",
        }

        return self.api_client.call_api(
            "/v1/data-sources/{data-source-id}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
