# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from importlib import import_module
from typing import TYPE_CHECKING, Optional, Union

from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist, constr

if TYPE_CHECKING:
    from earnix_elevate.clients.imx.models.create_bucket_data_source_request import (
        CreateBucketDataSourceRequest,
    )
    from earnix_elevate.clients.imx.models.create_delta_sharing_data_source_request import (
        CreateDeltaSharingDataSourceRequest,
    )
    from earnix_elevate.clients.imx.models.create_rdbms_data_source_request import (
        CreateRDBMSDataSourceRequest,
    )


class CreateDataSourceRequest(BaseModel):
    """
    `CreateDataSourceRequest`

    Request to create a new DataSource that defines how to import data from an external system. The request specifies the connection to use and the data location (path for storage systems, query for databases).
    """

    type: StrictStr = Field(
        default=...,
        description="The type of DataSource to create (bucket for cloud storage, rdbms for databases, delta sharing for shared data)",
    )
    name: constr(strict=True, max_length=100, min_length=3) = Field(
        default=...,
        description="The name of the entity for identification and display purposes",
    )
    description: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        description="Optional detailed description providing additional context about the entity",
    )
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(
        default=None,
        description="A list of unique tags for categorizing and organizing the entity",
    )
    connection_id: StrictInt = Field(
        default=...,
        alias="connectionId",
        description="The unique identifier of the Connection used by this DataSource",
    )
    __properties = ["name", "description", "tags", "connectionId"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = "type"

    # discriminator mappings
    __discriminator_value_class_map = {
        "bucket": "CreateBucketDataSourceRequest",
        "delta_sharing": "CreateDeltaSharingDataSourceRequest",
        "rdbms": "CreateRDBMSDataSourceRequest",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[
        CreateBucketDataSourceRequest,
        CreateDeltaSharingDataSourceRequest,
        CreateRDBMSDataSourceRequest,
    ]:
        """Create an instance of CreateDataSourceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[
        CreateBucketDataSourceRequest,
        CreateDeltaSharingDataSourceRequest,
        CreateRDBMSDataSourceRequest,
    ]:
        """Create an instance of CreateDataSourceRequest from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "CreateBucketDataSourceRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.create_bucket_data_source_request"
            ).CreateBucketDataSourceRequest.from_dict(obj)
        if object_type == "CreateDeltaSharingDataSourceRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.create_delta_sharing_data_source_request"
            ).CreateDeltaSharingDataSourceRequest.from_dict(obj)
        if object_type == "CreateRDBMSDataSourceRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.create_rdbms_data_source_request"
            ).CreateRDBMSDataSourceRequest.from_dict(obj)
        raise ValueError(
            "CreateDataSourceRequest failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
