# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from importlib import import_module
from typing import TYPE_CHECKING, Optional, Union

from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist, constr

if TYPE_CHECKING:
    from earnix_elevate.clients.imx.models.merge_delta_sharing_connection_request import (
        MergeDeltaSharingConnectionRequest,
    )
    from earnix_elevate.clients.imx.models.merge_price_it_dim_connection_request import (
        MergePriceItDimConnectionRequest,
    )
    from earnix_elevate.clients.imx.models.merge_s3_connection_request import (
        MergeS3ConnectionRequest,
    )
    from earnix_elevate.clients.imx.models.merge_snowflake_connection_request import (
        MergeSnowflakeConnectionRequest,
    )


class MergeConnectionRequest(BaseModel):
    """
    `MergeConnectionRequest`

    Request to partially update a Connection by applying only the provided fields while leaving other fields unchanged. Uses merge-patch semantics and requires the current lock version.
    """

    id: StrictInt = Field(
        default=..., description="The unique identifier of the entity"
    )
    lock_version: StrictInt = Field(
        default=...,
        alias="lockVersion",
        description="The current version of the entity used for optimistic locking to prevent concurrent modifications",
    )
    name: Optional[constr(strict=True, max_length=100, min_length=3)] = Field(
        default=None,
        description="The name of the entity for identification and display purposes",
    )
    description: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        description="Optional detailed description providing additional context about the entity",
    )
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(
        default=None,
        description="A list of unique tags for categorizing and organizing the entity",
    )
    type: StrictStr = Field(
        default=..., description="The type of Connection being merged (s3 or snowflake)"
    )
    __properties = ["id", "lockVersion", "name", "description", "tags", "type"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = "type"

    # discriminator mappings
    __discriminator_value_class_map = {
        "delta_sharing": "MergeDeltaSharingConnectionRequest",
        "priceit_dim": "MergePriceItDimConnectionRequest",
        "s3": "MergeS3ConnectionRequest",
        "snowflake": "MergeSnowflakeConnectionRequest",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[
        MergeDeltaSharingConnectionRequest,
        MergePriceItDimConnectionRequest,
        MergeS3ConnectionRequest,
        MergeSnowflakeConnectionRequest,
    ]:
        """Create an instance of MergeConnectionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[
        MergeDeltaSharingConnectionRequest,
        MergePriceItDimConnectionRequest,
        MergeS3ConnectionRequest,
        MergeSnowflakeConnectionRequest,
    ]:
        """Create an instance of MergeConnectionRequest from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "MergeDeltaSharingConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.merge_delta_sharing_connection_request"
            ).MergeDeltaSharingConnectionRequest.from_dict(obj)
        if object_type == "MergePriceItDimConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.merge_price_it_dim_connection_request"
            ).MergePriceItDimConnectionRequest.from_dict(obj)
        if object_type == "MergeS3ConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.merge_s3_connection_request"
            ).MergeS3ConnectionRequest.from_dict(obj)
        if object_type == "MergeSnowflakeConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.merge_snowflake_connection_request"
            ).MergeSnowflakeConnectionRequest.from_dict(obj)
        raise ValueError(
            "MergeConnectionRequest failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
