# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from importlib import import_module
from typing import TYPE_CHECKING, Optional, Union

from pydantic.v1 import BaseModel, Field, StrictStr

if TYPE_CHECKING:
    from earnix_elevate.clients.imx.models.snowflake_client_credentials_auth_response import (
        SnowflakeClientCredentialsAuthResponse,
    )
    from earnix_elevate.clients.imx.models.snowflake_password_auth_response import (
        SnowflakePasswordAuthResponse,
    )


class SnowflakeAuthResponse(BaseModel):
    """
    `SnowflakeAuthResponse`

    Authentication details for Snowflake Connections in response objects, supporting multiple authentication methods.
    """

    auth_type: Optional[StrictStr] = Field(
        default=None,
        alias="authType",
        description="The authentication method used for Snowflake access",
    )
    __properties = ["authType"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = "authType"

    # discriminator mappings
    __discriminator_value_class_map = {
        "snowflake_client_credentials": "SnowflakeClientCredentialsAuthResponse",
        "snowflake_password": "SnowflakePasswordAuthResponse",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[SnowflakeClientCredentialsAuthResponse, SnowflakePasswordAuthResponse]:
        """Create an instance of SnowflakeAuthResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[SnowflakeClientCredentialsAuthResponse, SnowflakePasswordAuthResponse]:
        """Create an instance of SnowflakeAuthResponse from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "SnowflakeClientCredentialsAuthResponse":
            return import_module(
                "earnix_elevate.clients.imx.models.snowflake_client_credentials_auth_response"
            ).SnowflakeClientCredentialsAuthResponse.from_dict(obj)
        if object_type == "SnowflakePasswordAuthResponse":
            return import_module(
                "earnix_elevate.clients.imx.models.snowflake_password_auth_response"
            ).SnowflakePasswordAuthResponse.from_dict(obj)
        raise ValueError(
            "SnowflakeAuthResponse failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
