# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint

from pydantic.v1 import Field, constr

from earnix_elevate.clients.imx.models.update_data_source_request import (
    UpdateDataSourceRequest,
)


class UpdateBucketDataSourceRequest(UpdateDataSourceRequest):
    """
    `UpdateBucketDataSourceRequest`

    Request to update a bucket-based DataSource, allowing modification of the storage path and other configuration settings.
    """

    path: constr(strict=True, max_length=1000) = Field(
        default=...,
        description="The path within the bucket where the data files are located",
    )
    __properties = [
        "type",
        "id",
        "lockVersion",
        "name",
        "description",
        "tags",
        "connectionId",
        "path",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateBucketDataSourceRequest:
        """Create an instance of UpdateBucketDataSourceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateBucketDataSourceRequest:
        """Create an instance of UpdateBucketDataSourceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateBucketDataSourceRequest.parse_obj(obj)

        _obj = UpdateBucketDataSourceRequest.parse_obj(
            {
                "type": obj.get("type"),
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "connection_id": obj.get("connectionId"),
                "path": obj.get("path"),
            }
        )
        return _obj
