# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictStr, conint, constr

from typing import Optional

from vrt_lss_account.models.account_audit_result import AccountAuditResult
from vrt_lss_account.models.method_group import MethodGroup
from vrt_lss_account.models.service_name import ServiceName

from vrt_lss_account.api_client import ApiClient
from vrt_lss_account.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AuditApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def read_audit(self, offset : Annotated[Optional[conint(strict=True, le=10000000, ge=0)], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[conint(strict=True, le=10000000, ge=1)], Field(description="The number of items to return.")] = None, var_from : Annotated[Optional[datetime], Field(description="Date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. ")] = None, to : Annotated[Optional[datetime], Field(description="Date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. ")] = None, service_name : Annotated[Optional[ServiceName], Field(description="Service name.")] = None, operation_id : Annotated[Optional[constr(strict=True, max_length=256, min_length=3)], Field(description="Operation identifier.")] = None, method_group : Annotated[Optional[MethodGroup], Field(description="Method group name.")] = None, sort_field : Annotated[Optional[constr(strict=True, max_length=64, min_length=1)], Field(description="Field to sort by.")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, **kwargs) -> AccountAuditResult:  # noqa: E501
        """Actions for the period  # noqa: E501

        User actions for the period.  If the period is not specified, records for the current day are returned from the beginning of the day to the current time. If no 'from' datetime is specified, audit data are returned from the beginning of the day. If no 'to' datetime is specified, audit data are returned be the end of the current day.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_audit(offset, limit, var_from, to, service_name, operation_id, method_group, sort_field, sort_direction, async_req=True)
        >>> result = thread.get()

        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param var_from: Date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. 
        :type var_from: datetime
        :param to: Date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. 
        :type to: datetime
        :param service_name: Service name.
        :type service_name: ServiceName
        :param operation_id: Operation identifier.
        :type operation_id: str
        :param method_group: Method group name.
        :type method_group: MethodGroup
        :param sort_field: Field to sort by.
        :type sort_field: str
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountAuditResult
        """
        kwargs['_return_http_data_only'] = True
        return self.read_audit_with_http_info(offset, limit, var_from, to, service_name, operation_id, method_group, sort_field, sort_direction, **kwargs)  # noqa: E501

    @validate_arguments
    def read_audit_with_http_info(self, offset : Annotated[Optional[conint(strict=True, le=10000000, ge=0)], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[conint(strict=True, le=10000000, ge=1)], Field(description="The number of items to return.")] = None, var_from : Annotated[Optional[datetime], Field(description="Date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. ")] = None, to : Annotated[Optional[datetime], Field(description="Date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. ")] = None, service_name : Annotated[Optional[ServiceName], Field(description="Service name.")] = None, operation_id : Annotated[Optional[constr(strict=True, max_length=256, min_length=3)], Field(description="Operation identifier.")] = None, method_group : Annotated[Optional[MethodGroup], Field(description="Method group name.")] = None, sort_field : Annotated[Optional[constr(strict=True, max_length=64, min_length=1)], Field(description="Field to sort by.")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, **kwargs):  # noqa: E501
        """Actions for the period  # noqa: E501

        User actions for the period.  If the period is not specified, records for the current day are returned from the beginning of the day to the current time. If no 'from' datetime is specified, audit data are returned from the beginning of the day. If no 'to' datetime is specified, audit data are returned be the end of the current day.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_audit_with_http_info(offset, limit, var_from, to, service_name, operation_id, method_group, sort_field, sort_direction, async_req=True)
        >>> result = thread.get()

        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param var_from: Date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. 
        :type var_from: datetime
        :param to: Date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. 
        :type to: datetime
        :param service_name: Service name.
        :type service_name: ServiceName
        :param operation_id: Operation identifier.
        :type operation_id: str
        :param method_group: Method group name.
        :type method_group: MethodGroup
        :param sort_field: Field to sort by.
        :type sort_field: str
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountAuditResult, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'offset',
            'limit',
            'var_from',
            'to',
            'service_name',
            'operation_id',
            'method_group',
            'sort_field',
            'sort_direction'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_audit" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_params.append(('from', _params['var_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_params.append(('to', _params['to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('to', _params['to']))

        if _params.get('service_name') is not None:  # noqa: E501
            _query_params.append(('service_name', _params['service_name']))

        if _params.get('operation_id') is not None:  # noqa: E501
            _query_params.append(('operation_id', _params['operation_id']))

        if _params.get('method_group') is not None:  # noqa: E501
            _query_params.append(('method_group', _params['method_group']))

        if _params.get('sort_field') is not None:  # noqa: E501
            _query_params.append(('sort_field', _params['sort_field']))

        if _params.get('sort_direction') is not None:  # noqa: E501
            _query_params.append(('sort_direction', _params['sort_direction']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountAuditResult",
            '400': "General400",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/account/audit', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
