# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field

from typing import Optional, Union

from vrt_lss_account.models.user_statistics import UserStatistics

from vrt_lss_account.api_client import ApiClient
from vrt_lss_account.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class StatisticsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def generate_statistics(self, var_from : Annotated[Optional[date], Field(description="Date 'from' in the YYYY-MM-DD format.")] = None, to : Annotated[Optional[date], Field(description="Date 'to' in the YYYY-MM-DD format.")] = None, **kwargs) -> UserStatistics:  # noqa: E501
        """Statistics for the period  # noqa: E501

        User statistics for the period. If the period is not specified, the statistics for the current month returns (from the beginning of the month to the present day). If no 'from' datetime is specified, data are returned from the beginning of the month. If no 'to' datetime is specified, data are returned be to the present day (excluding).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_statistics(var_from, to, async_req=True)
        >>> result = thread.get()

        :param var_from: Date 'from' in the YYYY-MM-DD format.
        :type var_from: date
        :param to: Date 'to' in the YYYY-MM-DD format.
        :type to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserStatistics
        """
        kwargs['_return_http_data_only'] = True
        return self.generate_statistics_with_http_info(var_from, to, **kwargs)  # noqa: E501

    @validate_arguments
    def generate_statistics_with_http_info(self, var_from : Annotated[Optional[date], Field(description="Date 'from' in the YYYY-MM-DD format.")] = None, to : Annotated[Optional[date], Field(description="Date 'to' in the YYYY-MM-DD format.")] = None, **kwargs):  # noqa: E501
        """Statistics for the period  # noqa: E501

        User statistics for the period. If the period is not specified, the statistics for the current month returns (from the beginning of the month to the present day). If no 'from' datetime is specified, data are returned from the beginning of the month. If no 'to' datetime is specified, data are returned be to the present day (excluding).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_statistics_with_http_info(var_from, to, async_req=True)
        >>> result = thread.get()

        :param var_from: Date 'from' in the YYYY-MM-DD format.
        :type var_from: date
        :param to: Date 'to' in the YYYY-MM-DD format.
        :type to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserStatistics, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'var_from',
            'to'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_statistics" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_parame.append(('from', _params['var_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_parame.append(('to', _params['to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('to', _params['to']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "UserStatistics",
            '400': "General400",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/account/statistics', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_report(self, var_from : Annotated[Optional[date], Field(description="Date 'from' in the YYYY-MM-DD format.")] = None, to : Annotated[Optional[date], Field(description="Date 'to' in the YYYY-MM-DD format.")] = None, **kwargs) -> bytearray:  # noqa: E501
        """Report creating  # noqa: E501

        Creating report with usage statistics. If the period is not specified, records are returned from the beginning of the month to the present day (excluding). If no 'from' datetime is specified, data are returned from the beginning of the month. If no 'to' datetime is specified, data are returned be the the present day (excluding).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_report(var_from, to, async_req=True)
        >>> result = thread.get()

        :param var_from: Date 'from' in the YYYY-MM-DD format.
        :type var_from: date
        :param to: Date 'to' in the YYYY-MM-DD format.
        :type to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        return self.read_report_with_http_info(var_from, to, **kwargs)  # noqa: E501

    @validate_arguments
    def read_report_with_http_info(self, var_from : Annotated[Optional[date], Field(description="Date 'from' in the YYYY-MM-DD format.")] = None, to : Annotated[Optional[date], Field(description="Date 'to' in the YYYY-MM-DD format.")] = None, **kwargs):  # noqa: E501
        """Report creating  # noqa: E501

        Creating report with usage statistics. If the period is not specified, records are returned from the beginning of the month to the present day (excluding). If no 'from' datetime is specified, data are returned from the beginning of the month. If no 'to' datetime is specified, data are returned be the the present day (excluding).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_report_with_http_info(var_from, to, async_req=True)
        >>> result = thread.get()

        :param var_from: Date 'from' in the YYYY-MM-DD format.
        :type var_from: date
        :param to: Date 'to' in the YYYY-MM-DD format.
        :type to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'var_from',
            'to'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_report" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_parame.append(('from', _params['var_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_parame.append(('to', _params['to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('to', _params['to']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "General400",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/account/report', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
