# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, conint, constr, validator

class AccountInfo(BaseModel):
    """
    User information.
    """
    username: constr(strict=True, max_length=256, min_length=2) = Field(..., description="Login, unique identifier.")
    name: Optional[constr(strict=True, max_length=256, min_length=2)] = Field(None, description="Full name of user.")
    email: Optional[constr(strict=True, max_length=256, min_length=5)] = Field(None, description="User mail address.")
    phone: Optional[constr(strict=True, max_length=32, min_length=5)] = Field(None, description="User phone.")
    company_key: constr(strict=True, max_length=256, min_length=3) = Field(..., description="Company key.")
    timezone: Optional[conint(strict=True, le=12, ge=-12)] = Field(0, description="Basic time zone used for statistics.")
    __properties = ["username", "name", "email", "phone", "company_key", "timezone"]

    @validator('username')
    def username_validate_regular_expression(cls, v):
        if not re.match(r"\w+", v):
            raise ValueError(r"must validate the regular expression /\w+/")
        return v

    @validator('company_key')
    def company_key_validate_regular_expression(cls, v):
        if not re.match(r"\w+", v):
            raise ValueError(r"must validate the regular expression /\w+/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountInfo:
        """Create an instance of AccountInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if email (nullable) is None
        # and __fields_set__ contains the field
        if self.email is None and "email" in self.__fields_set__:
            _dict['email'] = None

        # set to None if phone (nullable) is None
        # and __fields_set__ contains the field
        if self.phone is None and "phone" in self.__fields_set__:
            _dict['phone'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountInfo:
        """Create an instance of AccountInfo from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountInfo.parse_obj(obj)

        _obj = AccountInfo.parse_obj({
            "username": obj.get("username"),
            "name": obj.get("name"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "company_key": obj.get("company_key"),
            "timezone": obj.get("timezone") if obj.get("timezone") is not None else 0
        })
        return _obj

