# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, constr, validator
from vrt_lss_account.models.audit_action_statistics import AuditActionStatistics
from vrt_lss_account.models.method_group import MethodGroup
from vrt_lss_account.models.tracedata import Tracedata

class AuditAction(BaseModel):
    """
    User action.
    """
    username: constr(strict=True, max_length=256, min_length=2) = Field(..., description="Login, unique identifier.")
    company_key: constr(strict=True, max_length=256, min_length=3) = Field(..., description="Company key.")
    tracedata: Tracedata = Field(...)
    method_group: MethodGroup = Field(...)
    statistics: AuditActionStatistics = Field(...)
    __properties = ["username", "company_key", "tracedata", "method_group", "statistics"]

    @validator('username')
    def username_validate_regular_expression(cls, v):
        if not re.match(r"\w+", v):
            raise ValueError(r"must validate the regular expression /\w+/")
        return v

    @validator('company_key')
    def company_key_validate_regular_expression(cls, v):
        if not re.match(r"\w+", v):
            raise ValueError(r"must validate the regular expression /\w+/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuditAction:
        """Create an instance of AuditAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of tracedata
        if self.tracedata:
            _dict['tracedata'] = self.tracedata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuditAction:
        """Create an instance of AuditAction from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AuditAction.parse_obj(obj)

        _obj = AuditAction.parse_obj({
            "username": obj.get("username"),
            "company_key": obj.get("company_key"),
            "tracedata": Tracedata.from_dict(obj.get("tracedata")) if obj.get("tracedata") is not None else None,
            "method_group": obj.get("method_group"),
            "statistics": AuditActionStatistics.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None
        })
        return _obj

