# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, conint
from vrt_lss_account.models.method_group import MethodGroup

class MethodStatistics(BaseModel):
    """
    Usage statistics of the service method.
    """
    method_group: MethodGroup = Field(...)
    unique_points_per_day: conint(strict=True, le=10000000, ge=0) = Field(..., description="Unique points per day.")
    points_per_day: conint(strict=True, le=10000000, ge=0) = Field(..., description="Non-unique points per day.")
    __properties = ["method_group", "unique_points_per_day", "points_per_day"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MethodStatistics:
        """Create an instance of MethodStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MethodStatistics:
        """Create an instance of MethodStatistics from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MethodStatistics.parse_obj(obj)

        _obj = MethodStatistics.parse_obj({
            "method_group": obj.get("method_group"),
            "unique_points_per_day": obj.get("unique_points_per_day"),
            "points_per_day": obj.get("points_per_day")
        })
        return _obj

