# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from vrt_lss_account.models.method_statistics import MethodStatistics
from vrt_lss_account.models.service_name import ServiceName

class ServiceStatistics(BaseModel):
    """
    Usage statistics of all service methods.
    """
    service: ServiceName = Field(...)
    methods: conlist(MethodStatistics, max_items=100, min_items=1) = Field(..., description="Usage statistics list of the specified service methods.")
    __properties = ["service", "methods"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceStatistics:
        """Create an instance of ServiceStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in methods (list)
        _items = []
        if self.methods:
            for _item in self.methods:
                if _item:
                    _items.append(_item.to_dict())
            _dict['methods'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceStatistics:
        """Create an instance of ServiceStatistics from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ServiceStatistics.parse_obj(obj)

        _obj = ServiceStatistics.parse_obj({
            "service": obj.get("service"),
            "methods": [MethodStatistics.from_dict(_item) for _item in obj.get("methods")] if obj.get("methods") is not None else None
        })
        return _obj

