# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, conint, constr, validator

class TokenRequest(BaseModel):
    """
    Token obtaining data.
    """
    username: constr(strict=True, max_length=256, min_length=2) = Field(..., description="Login, unique identifier.")
    password: constr(strict=True, max_length=1000, min_length=1) = Field(..., description="Password.")
    ttl_seconds: Optional[conint(strict=True, le=31556926, ge=60)] = Field(86400, description="Token validity time, in seconds.")
    __properties = ["username", "password", "ttl_seconds"]

    @validator('username')
    def username_validate_regular_expression(cls, v):
        if not re.match(r"\w+", v):
            raise ValueError(r"must validate the regular expression /\w+/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TokenRequest:
        """Create an instance of TokenRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TokenRequest:
        """Create an instance of TokenRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TokenRequest.parse_obj(obj)

        _obj = TokenRequest.parse_obj({
            "username": obj.get("username"),
            "password": obj.get("password"),
            "ttl_seconds": obj.get("ttl_seconds") if obj.get("ttl_seconds") is not None else 86400
        })
        return _obj

