# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist, constr, validator
from vrt_lss_account.models.date_statistics import DateStatistics

class UserStatistics(BaseModel):
    """
    Usage service statistics by the specific user.
    """
    username: constr(strict=True, max_length=256, min_length=2) = Field(..., description="Login, unique identifier.")
    dates: conlist(DateStatistics, max_items=3653, min_items=0) = Field(..., description="Statistics list for each day for the specified user.")
    __properties = ["username", "dates"]

    @validator('username')
    def username_validate_regular_expression(cls, v):
        if not re.match(r"\w+", v):
            raise ValueError(r"must validate the regular expression /\w+/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UserStatistics:
        """Create an instance of UserStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in dates (list)
        _items = []
        if self.dates:
            for _item in self.dates:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UserStatistics:
        """Create an instance of UserStatistics from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return UserStatistics.parse_obj(obj)

        _obj = UserStatistics.parse_obj({
            "username": obj.get("username"),
            "dates": [DateStatistics.from_dict(_item) for _item in obj.get("dates")] if obj.get("dates") is not None else None
        })
        return _obj

