# generated by datamodel-codegen:
#   filename:  api/data/createCustomProperty.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, customProperty


class CreateCustomPropertyRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this Custom Property model.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies the custom property.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Container instance.'),
    ]
    propertyType: Annotated[
        customProperty.PropertyType, Field(description='Property Type.')
    ]
    customPropertyConfig: Annotated[
        Optional[customProperty.CustomPropertyConfig],
        Field(None, description='Config to define constraints around CustomProperty.'),
    ]
