# generated by datamodel-codegen:
#   filename:  api/feed/createThread.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.feed import thread
from ...type import basic, entityReferenceList


class CreateTaskDetails(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: thread.TaskType
    assignees: Annotated[
        entityReferenceList.EntityReferenceList,
        Field(description='List of users or teams the task is assigned to'),
    ]
    oldValue: Annotated[
        Optional[str],
        Field(
            None, description='The value of old object for which the task is created.'
        ),
    ]
    suggestion: Annotated[
        Optional[str],
        Field(
            None,
            description='The suggestion object for the task provided by the creator.',
        ),
    ]


class CreateThreadRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    message: Annotated[str, Field(description='Message')]
    from_: Annotated[
        str,
        Field(
            alias='from',
            description='Name of the User (regular user or bot) posting the message',
        ),
    ]
    addressedTo: Annotated[
        Optional[basic.EntityLink],
        Field(
            None,
            description='User or team this thread is addressed to in format <#E::{entities}::{entityName}::{field}::{fieldValue}.',
        ),
    ]
    about: Annotated[
        basic.EntityLink,
        Field(
            description='Data asset about which this thread is created for with format <#E::{entities}::{entityType}::{field}::{fieldValue}'
        ),
    ]
    type: Optional[thread.ThreadType] = thread.ThreadType.Conversation
    taskDetails: Optional[CreateTaskDetails] = None
    announcementDetails: Optional[thread.AnnouncementDetails] = None
    chatbotDetails: Annotated[
        Optional[thread.ChatbotDetails],
        Field(
            None,
            description='Details about the Chatbot conversation. This is only applicable if thread is of type Chatbot.',
        ),
    ]
