# generated by datamodel-codegen:
#   filename:  configuration/profilerConfiguration.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..entity.data import table


class MetricType(Enum):
    mean = 'mean'
    valuesCount = 'valuesCount'
    countInSet = 'countInSet'
    columnCount = 'columnCount'
    distinctCount = 'distinctCount'
    distinctProportion = 'distinctProportion'
    iLikeCount = 'iLikeCount'
    likeCount = 'likeCount'
    notLikeCount = 'notLikeCount'
    regexCount = 'regexCount'
    notRegexCount = 'notRegexCount'
    max = 'max'
    maxLength = 'maxLength'
    min = 'min'
    minLength = 'minLength'
    nullCount = 'nullCount'
    rowCount = 'rowCount'
    stddev = 'stddev'
    sum = 'sum'
    uniqueCount = 'uniqueCount'
    uniqueProportion = 'uniqueProportion'
    columnNames = 'columnNames'
    duplicateCount = 'duplicateCount'
    iLikeRatio = 'iLikeRatio'
    likeRatio = 'likeRatio'
    nullProportion = 'nullProportion'
    interQuartileRange = 'interQuartileRange'
    nonParametricSkew = 'nonParametricSkew'
    median = 'median'
    firstQuartile = 'firstQuartile'
    thirdQuartile = 'thirdQuartile'
    system = 'system'
    histogram = 'histogram'


class MetricConfigurationDefinition(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dataType: Optional[table.DataType] = None
    metrics: Optional[List[MetricType]] = None
    disabled: Annotated[
        Optional[bool],
        Field(
            False,
            description='If true, the metric will not be computed for the data type.',
        ),
    ]


class ProfilerConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metricConfiguration: Optional[List[MetricConfigurationDefinition]] = None
