# generated by datamodel-codegen:
#   filename:  entity/applications/appRunRecord.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic
from . import app


class Status(Enum):
    started = 'started'
    running = 'running'
    completed = 'completed'
    failed = 'failed'
    active = 'active'
    activeError = 'activeError'
    stopped = 'stopped'
    success = 'success'
    pending = 'pending'


class AppRunRecord(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    appId: Annotated[
        Optional[basic.Uuid],
        Field(
            None,
            description='Unique identifier of this application for which the job is ran.',
        ),
    ]
    appName: Annotated[
        Optional[basic.EntityName], Field(None, description='Name of the application.')
    ]
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Update time of the job status.'),
    ]
    extension: Annotated[Optional[str], Field('status', description='Extension type.')]
    status: Annotated[Optional[Status], Field(None, description='Status for the Job.')]
    runType: Annotated[
        Optional[str],
        Field(None, description='This schema defines the type of application Run.'),
    ]
    startTime: Annotated[
        Optional[basic.Timestamp], Field(None, description='Start of the job status.')
    ]
    endTime: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='End time of the job status.'),
    ]
    executionTime: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Execution time of the job status.'),
    ]
    failureContext: Annotated[
        Optional[Dict[str, Any]],
        Field(None, description='Failure Context for the Application.'),
    ]
    successContext: Annotated[
        Optional[Dict[str, Any]],
        Field(None, description='Success Context for the Application.'),
    ]
    scheduleInfo: Optional[app.AppSchedule] = None
    config: Optional[basic.Map] = None
