# generated by datamodel-codegen:
#   filename:  entity/data/table.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import AwareDatetime, ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...tests import customMetric
from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import databaseService


class ProfileSampleType(Enum):
    PERCENTAGE = 'PERCENTAGE'
    ROWS = 'ROWS'


class SamplingMethodType(Enum):
    BERNOULLI = 'BERNOULLI'
    SYSTEM = 'SYSTEM'


class TableType(Enum):
    Regular = 'Regular'
    External = 'External'
    Dynamic = 'Dynamic'
    View = 'View'
    SecureView = 'SecureView'
    MaterializedView = 'MaterializedView'
    Iceberg = 'Iceberg'
    Local = 'Local'
    Partitioned = 'Partitioned'
    Foreign = 'Foreign'
    Transient = 'Transient'


class DataType(Enum):
    NUMBER = 'NUMBER'
    TINYINT = 'TINYINT'
    SMALLINT = 'SMALLINT'
    INT = 'INT'
    BIGINT = 'BIGINT'
    BYTEINT = 'BYTEINT'
    BYTES = 'BYTES'
    FLOAT = 'FLOAT'
    DOUBLE = 'DOUBLE'
    DECIMAL = 'DECIMAL'
    NUMERIC = 'NUMERIC'
    TIMESTAMP = 'TIMESTAMP'
    TIMESTAMPZ = 'TIMESTAMPZ'
    TIME = 'TIME'
    DATE = 'DATE'
    DATETIME = 'DATETIME'
    INTERVAL = 'INTERVAL'
    STRING = 'STRING'
    MEDIUMTEXT = 'MEDIUMTEXT'
    TEXT = 'TEXT'
    CHAR = 'CHAR'
    LONG = 'LONG'
    VARCHAR = 'VARCHAR'
    BOOLEAN = 'BOOLEAN'
    BINARY = 'BINARY'
    VARBINARY = 'VARBINARY'
    ARRAY = 'ARRAY'
    BLOB = 'BLOB'
    LONGBLOB = 'LONGBLOB'
    MEDIUMBLOB = 'MEDIUMBLOB'
    MAP = 'MAP'
    STRUCT = 'STRUCT'
    UNION = 'UNION'
    SET = 'SET'
    GEOGRAPHY = 'GEOGRAPHY'
    ENUM = 'ENUM'
    JSON = 'JSON'
    UUID = 'UUID'
    VARIANT = 'VARIANT'
    GEOMETRY = 'GEOMETRY'
    BYTEA = 'BYTEA'
    AGGREGATEFUNCTION = 'AGGREGATEFUNCTION'
    ERROR = 'ERROR'
    FIXED = 'FIXED'
    RECORD = 'RECORD'
    NULL = 'NULL'
    SUPER = 'SUPER'
    HLLSKETCH = 'HLLSKETCH'
    PG_LSN = 'PG_LSN'
    PG_SNAPSHOT = 'PG_SNAPSHOT'
    TSQUERY = 'TSQUERY'
    TXID_SNAPSHOT = 'TXID_SNAPSHOT'
    XML = 'XML'
    MACADDR = 'MACADDR'
    TSVECTOR = 'TSVECTOR'
    UNKNOWN = 'UNKNOWN'
    CIDR = 'CIDR'
    INET = 'INET'
    CLOB = 'CLOB'
    ROWID = 'ROWID'
    LOWCARDINALITY = 'LOWCARDINALITY'
    YEAR = 'YEAR'
    POINT = 'POINT'
    POLYGON = 'POLYGON'
    TUPLE = 'TUPLE'
    SPATIAL = 'SPATIAL'
    TABLE = 'TABLE'
    NTEXT = 'NTEXT'
    IMAGE = 'IMAGE'
    IPV4 = 'IPV4'
    IPV6 = 'IPV6'
    DATETIMERANGE = 'DATETIMERANGE'
    HLL = 'HLL'
    LARGEINT = 'LARGEINT'
    QUANTILE_STATE = 'QUANTILE_STATE'
    AGG_STATE = 'AGG_STATE'
    BITMAP = 'BITMAP'
    UINT = 'UINT'
    BIT = 'BIT'
    MONEY = 'MONEY'
    MEASURE_HIDDEN = 'MEASURE HIDDEN'
    MEASURE_VISIBLE = 'MEASURE VISIBLE'


class Constraint(Enum):
    NULL = 'NULL'
    NOT_NULL = 'NOT_NULL'
    UNIQUE = 'UNIQUE'
    PRIMARY_KEY = 'PRIMARY_KEY'


class ConstraintType(Enum):
    UNIQUE = 'UNIQUE'
    PRIMARY_KEY = 'PRIMARY_KEY'
    FOREIGN_KEY = 'FOREIGN_KEY'
    SORT_KEY = 'SORT_KEY'
    DIST_KEY = 'DIST_KEY'
    CLUSTER_KEY = 'CLUSTER_KEY'


class RelationshipType(Enum):
    ONE_TO_ONE = 'ONE_TO_ONE'
    ONE_TO_MANY = 'ONE_TO_MANY'
    MANY_TO_ONE = 'MANY_TO_ONE'
    MANY_TO_MANY = 'MANY_TO_MANY'


class TableConstraint(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    constraintType: Optional[ConstraintType] = None
    columns: Annotated[
        Optional[List[str]],
        Field(
            None, description='List of column names corresponding to the constraint.'
        ),
    ]
    referredColumns: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(None, description='List of referred columns for the constraint.'),
    ]
    relationshipType: Optional[RelationshipType] = None


class ColumnName(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Local name (not fully qualified name) of the column. ColumnName is `-` when the column is not named in struct dataType. For example, BigQuery supports struct with unnamed fields.',
            max_length=256,
            min_length=1,
            
        ),
    ]


class PartitionIntervalTypes(Enum):
    TIME_UNIT = 'TIME-UNIT'
    INTEGER_RANGE = 'INTEGER-RANGE'
    INGESTION_TIME = 'INGESTION-TIME'
    COLUMN_VALUE = 'COLUMN-VALUE'
    INJECTED = 'INJECTED'
    ENUM = 'ENUM'
    OTHER = 'OTHER'


class PartitionColumnDetails(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    columnName: Annotated[
        Optional[str],
        Field(None, description='List of column names corresponding to the partition.'),
    ]
    intervalType: Optional[PartitionIntervalTypes] = None
    interval: Annotated[
        Optional[str],
        Field(None, description='partition interval , example hourly, daily, monthly.'),
    ]


class JoinedWith(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    fullyQualifiedName: basic.FullyQualifiedEntityName
    joinCount: int


class ColumnJoins(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    columnName: Optional[ColumnName] = None
    joinedWith: Annotated[
        Optional[List[JoinedWith]],
        Field(
            None,
            description='Fully qualified names of the columns that this column is joined with.',
        ),
    ]


class TableJoins(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    startDate: Annotated[
        Optional[basic.Date],
        Field(
            None, description='Date can be only from today going back to last 29 days.'
        ),
    ]
    dayCount: Optional[int] = 1
    columnJoins: Optional[List[ColumnJoins]] = None
    directTableJoins: Annotated[
        Optional[List[JoinedWith]],
        Field(
            None,
            description='Joins with other tables that are not on a specific column (e.g: UNION join)',
        ),
    ]


class TableData(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    columns: Annotated[
        Optional[List[ColumnName]],
        Field(
            None,
            description='List of local column names (not fully qualified column names) of the table.',
        ),
    ]
    rows: Annotated[
        Optional[List[List]],
        Field(None, description='Data for multiple rows of the table.'),
    ]


class CustomMetricProfile(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[Optional[str], Field(None, description='Custom metric name.')]
    value: Annotated[
        Optional[float], Field(None, description='Profiling results for the metric.')
    ]


class Histogram(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    boundaries: Annotated[
        Optional[List], Field(None, description='Boundaries of Histogram.')
    ]
    frequencies: Annotated[
        Optional[List], Field(None, description='Frequencies of Histogram.')
    ]


class ColumnProfile(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[str, Field(description='Column Name.')]
    timestamp: Annotated[
        basic.Timestamp, Field(description='Timestamp on which profile is taken.')
    ]
    valuesCount: Annotated[
        Optional[float],
        Field(None, description='Total count of the values in this column.'),
    ]
    valuesPercentage: Annotated[
        Optional[float],
        Field(
            None,
            description='Percentage of values in this column with respect to row count.',
        ),
    ]
    validCount: Annotated[
        Optional[float],
        Field(None, description='Total count of valid values in this column.'),
    ]
    duplicateCount: Annotated[
        Optional[float],
        Field(None, description='No.of Rows that contain duplicates in a column.'),
    ]
    nullCount: Annotated[
        Optional[float], Field(None, description='No.of null values in a column.')
    ]
    nullProportion: Annotated[
        Optional[float],
        Field(None, description='No.of null value proportion in columns.'),
    ]
    missingPercentage: Annotated[
        Optional[float],
        Field(
            None,
            description='Missing Percentage is calculated by taking percentage of validCount/valuesCount.',
        ),
    ]
    missingCount: Annotated[
        Optional[float],
        Field(
            None,
            description='Missing count is calculated by subtracting valuesCount - validCount.',
        ),
    ]
    uniqueCount: Annotated[
        Optional[float], Field(None, description='No. of unique values in the column.')
    ]
    uniqueProportion: Annotated[
        Optional[float],
        Field(None, description='Proportion of number of unique values in a column.'),
    ]
    distinctCount: Annotated[
        Optional[float],
        Field(None, description='Number of values that contain distinct values.'),
    ]
    distinctProportion: Annotated[
        Optional[float],
        Field(None, description='Proportion of distinct values in a column.'),
    ]
    min: Annotated[
        Optional[Union[float, int, basic.DateTime, basic.Time, basic.Date, str]],
        Field(None, description='Minimum value in a column.'),
    ]
    max: Annotated[
        Optional[Union[float, int, basic.DateTime, basic.Time, basic.Date, str]],
        Field(None, description='Maximum value in a column.'),
    ]
    minLength: Annotated[
        Optional[float], Field(None, description='Minimum string length in a column.')
    ]
    maxLength: Annotated[
        Optional[float], Field(None, description='Maximum string length in a column.')
    ]
    mean: Annotated[Optional[float], Field(None, description='Avg value in a column.')]
    sum: Annotated[
        Optional[float], Field(None, description='Median value in a column.')
    ]
    stddev: Annotated[
        Optional[float], Field(None, description='Standard deviation of a column.')
    ]
    variance: Annotated[
        Optional[float], Field(None, description='Variance of a column.')
    ]
    median: Annotated[Optional[float], Field(None, description='Median of a column.')]
    firstQuartile: Annotated[
        Optional[float], Field(None, description='First quartile of a column.')
    ]
    thirdQuartile: Annotated[
        Optional[float], Field(None, description='First quartile of a column.')
    ]
    interQuartileRange: Annotated[
        Optional[float], Field(None, description='Inter quartile range of a column.')
    ]
    nonParametricSkew: Annotated[
        Optional[float], Field(None, description='Non parametric skew of a column.')
    ]
    histogram: Annotated[
        Optional[Histogram], Field(None, description='Histogram of a column.')
    ]
    customMetrics: Annotated[
        Optional[List[CustomMetricProfile]],
        Field(None, description='Custom Metrics profile list bound to a column.'),
    ]


class DmlOperationType(Enum):
    UPDATE = 'UPDATE'
    INSERT = 'INSERT'
    DELETE = 'DELETE'


class SystemProfile(BaseModel):
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Timestamp on which profile is taken.'),
    ]
    operation: Annotated[
        Optional[DmlOperationType], Field(None, description='Operation performed.')
    ]
    rowsAffected: Annotated[
        Optional[int], Field(None, description='Number of rows affected.')
    ]


class ColumnProfilerConfig(BaseModel):
    columnName: Annotated[
        Optional[str],
        Field(None, description='Column Name of the table to be included.'),
    ]
    metrics: Annotated[
        Optional[List[str]], Field(None, description='Include only following metrics.')
    ]


class PartitionIntervalUnit(Enum):
    YEAR = 'YEAR'
    MONTH = 'MONTH'
    DAY = 'DAY'
    HOUR = 'HOUR'


class PartitionProfilerConfig(BaseModel):
    enablePartitioning: Annotated[
        Optional[bool], Field(False, description='whether to use partition')
    ]
    partitionColumnName: Annotated[
        Optional[str],
        Field(None, description='name of the column to use for the partition'),
    ]
    partitionIntervalType: Optional[PartitionIntervalTypes] = None
    partitionInterval: Annotated[
        Optional[int],
        Field(None, description='The interval to use for the partitioning'),
    ]
    partitionIntervalUnit: Annotated[
        Optional[PartitionIntervalUnit],
        Field(None, description='unit used for the partition interval'),
    ]
    partitionValues: Annotated[
        Optional[List], Field(None, description='unit used for the partition interval')
    ]
    partitionIntegerRangeStart: Annotated[
        Optional[int],
        Field(None, description='start of the integer range for partitioning'),
    ]
    partitionIntegerRangeEnd: Annotated[
        Optional[int],
        Field(None, description='end of the integer range for partitioning'),
    ]


class TableProfilerConfig(BaseModel):
    profileSampleType: Optional[ProfileSampleType] = ProfileSampleType.PERCENTAGE
    profileSample: Annotated[
        Optional[float],
        Field(
            None,
            description='Percentage of data or no. of rows used to compute the profiler metrics and run data quality tests',
        ),
    ]
    samplingMethodType: Optional[SamplingMethodType] = None
    sampleDataCount: Annotated[
        Optional[int],
        Field(
            50,
            description="Number of sample rows to ingest when 'Generate Sample Data' is enabled",
            title='Sample Data Rows Count',
        ),
    ]
    profileQuery: Annotated[
        Optional[str],
        Field(
            None,
            description="Users' raw SQL query to fetch sample data and profile the table",
        ),
    ]
    excludeColumns: Annotated[
        Optional[List[str]],
        Field(None, description='column names to exclude from profiling.'),
    ]
    includeColumns: Annotated[
        Optional[List[ColumnProfilerConfig]],
        Field(
            None,
            description='Only run profiler on included columns with specific metrics.',
        ),
    ]
    partitioning: Annotated[
        Optional[PartitionProfilerConfig],
        Field(None, description='Partitioning configuration'),
    ]
    computeTableMetrics: Annotated[
        Optional[bool],
        Field(
            True,
            description='Option to turn on/off table metric computation. If enabled, profiler will compute table level metrics.',
            title='Compute Table Metrics',
        ),
    ]
    computeColumnMetrics: Annotated[
        Optional[bool],
        Field(
            True,
            description='Option to turn on/off column metric computation. If enabled, profiler will compute column level metrics.',
            title='Compute Column Metrics',
        ),
    ]


class TableProfile(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    timestamp: Annotated[
        basic.Timestamp, Field(description='Timestamp on which profile is taken.')
    ]
    profileSample: Annotated[
        Optional[float],
        Field(
            None,
            description='Percentage of data or no. of rows we want to execute the profiler and tests on',
        ),
    ]
    profileSampleType: Optional[ProfileSampleType] = ProfileSampleType.PERCENTAGE
    samplingMethodType: Optional[SamplingMethodType] = None
    columnCount: Annotated[
        Optional[float], Field(None, description='No.of columns in the table.')
    ]
    rowCount: Annotated[
        Optional[float],
        Field(
            None,
            description='No.of rows in the table. This is always executed on the whole table.',
        ),
    ]
    sizeInByte: Annotated[Optional[float], Field(None, description='Table size in GB')]
    createDateTime: Annotated[
        Optional[AwareDatetime], Field(None, description='Table creation time.')
    ]
    customMetrics: Annotated[
        Optional[List[CustomMetricProfile]],
        Field(None, description='Custom Metrics profile list bound to a column.'),
    ]


class ModelType(Enum):
    DBT = 'DBT'
    DDL = 'DDL'


class FileFormat(Enum):
    csv = 'csv'
    tsv = 'tsv'
    avro = 'avro'
    parquet = 'parquet'
    json = 'json'
    json_gz = 'json.gz'
    json_zip = 'json.zip'
    jsonl = 'jsonl'
    jsonl_gz = 'jsonl.gz'
    jsonl_zip = 'jsonl.zip'


class TablePartition(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    columns: Annotated[
        Optional[List[PartitionColumnDetails]],
        Field(
            None, description='List of column partitions with their type and interval.'
        ),
    ]


class Column(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: ColumnName
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this column name.'),
    ]
    dataType: Annotated[
        DataType, Field(description='Data type of the column (int, date etc.).')
    ]
    arrayDataType: Annotated[
        Optional[DataType],
        Field(
            None,
            description='Data type used array in dataType. For example, `array<int>` has dataType as `array` and arrayDataType as `int`.',
        ),
    ]
    dataLength: Annotated[
        Optional[int],
        Field(
            None,
            description='Length of `char`, `varchar`, `binary`, `varbinary` `dataTypes`, else null. For example, `varchar(20)` has dataType as `varchar` and dataLength as `20`.',
        ),
    ]
    precision: Annotated[
        Optional[int],
        Field(
            None,
            description='The precision of a numeric is the total count of significant digits in the whole number, that is, the number of digits to both sides of the decimal point. Precision is applicable Integer types, such as `INT`, `SMALLINT`, `BIGINT`, etc. It also applies to other Numeric types, such as `NUMBER`, `DECIMAL`, `DOUBLE`, `FLOAT`, etc.',
        ),
    ]
    scale: Annotated[
        Optional[int],
        Field(
            None,
            description='The scale of a numeric is the count of decimal digits in the fractional part, to the right of the decimal point. For Integer types, the scale is `0`. It mainly applies to non Integer Numeric types, such as `NUMBER`, `DECIMAL`, `DOUBLE`, `FLOAT`, etc.',
        ),
    ]
    dataTypeDisplay: Annotated[
        Optional[str],
        Field(
            None,
            description='Display name used for dataType. This is useful for complex types, such as `array<int>`, `map<int,string>`, `struct<>`, and union types.',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the column.')
    ]
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = None
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags associated with the column.'),
    ]
    constraint: Annotated[
        Optional[Constraint], Field(None, description='Column level constraint.')
    ]
    ordinalPosition: Annotated[
        Optional[int], Field(None, description='Ordinal position of the column.')
    ]
    jsonSchema: Annotated[
        Optional[str],
        Field(None, description='Json schema only if the dataType is JSON else null.'),
    ]
    children: Annotated[
        Optional[List[Column]],
        Field(
            None,
            description='Child columns if dataType or arrayDataType is `map`, `struct`, or `union` else `null`.',
        ),
    ]
    profile: Annotated[
        Optional[ColumnProfile],
        Field(None, description='Latest Data profile for a Column.'),
    ]
    customMetrics: Annotated[
        Optional[List[customMetric.CustomMetric]],
        Field(None, description='List of Custom Metrics registered for a table.'),
    ]


class DataModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    modelType: ModelType
    resourceType: Annotated[
        Optional[str], Field(None, description='Resource Type of the model.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Table from the model.'),
    ]
    path: Annotated[
        Optional[str], Field(None, description='Path to sql definition file.')
    ]
    rawSql: Annotated[
        Optional[basic.SqlQuery],
        Field(
            None,
            description='This corresponds to rws SQL from `<model_name>.sql` in DBT. This might be null when SQL query need not be compiled as done in DBT.',
        ),
    ]
    sql: Annotated[
        Optional[basic.SqlQuery],
        Field(
            None,
            description='This corresponds to compile SQL from `<model_name>.sql` in DBT. In cases where compilation is not necessary, this corresponds to SQL that created the table.',
        ),
    ]
    upstream: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified name of Models/tables used for in `sql` for creating this table.',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Table.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this data model.'),
    ]
    columns: Annotated[
        Optional[List[Column]],
        Field(
            None,
            description='Columns from the schema defined during modeling. In case of DBT, the metadata here comes from `schema.yaml`.',
        ),
    ]
    generatedAt: Optional[basic.DateTime] = None


class Table(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of this table instance.')
    ]
    name: Annotated[
        basic.EntityName,
        Field(description='Name of a table. Expected to be unique within a database.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this table. It could be title or label from the source services.',
        ),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='Fully qualified name of a table in the form `serviceName.databaseName.tableName`.',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of a table.')
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href], Field(None, description='Link to this table resource.')
    ]
    tableType: Optional[TableType] = None
    columns: Annotated[List[Column], Field(description='Columns in this table.')]
    tableConstraints: Annotated[
        Optional[List[TableConstraint]], Field(None, description='Table constraints.')
    ]
    tablePartition: Optional[TablePartition] = None
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this table.'),
    ]
    databaseSchema: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None, description='Reference to database schema that contains this table.'
        ),
    ]
    database: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Reference to Database that contains this table.'),
    ]
    service: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Link to Database service this table is hosted in.'),
    ]
    serviceType: Annotated[
        Optional[databaseService.DatabaseServiceType],
        Field(None, description='Service type this table is hosted in.'),
    ]
    location: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Reference to the Location that contains this table.'),
    ]
    locationPath: Annotated[
        Optional[str],
        Field(
            None,
            description='Full storage path in case of external and managed tables.',
        ),
    ]
    schemaDefinition: Annotated[
        Optional[basic.SqlQuery], Field(None, description='DDL for Tables and Views')
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this table.'),
    ]
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this table.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this table.'),
    ]
    joins: Annotated[
        Optional[TableJoins],
        Field(
            None,
            description='Details of other tables this table is frequently joined with.',
        ),
    ]
    sampleData: Annotated[
        Optional[TableData], Field(None, description='Sample data for a table.')
    ]
    tableProfilerConfig: Annotated[
        Optional[TableProfilerConfig],
        Field(
            None,
            description='Table Profiler Config to include or exclude columns from profiling.',
        ),
    ]
    customMetrics: Annotated[
        Optional[List[customMetric.CustomMetric]],
        Field(None, description='List of Custom Metrics registered for a table.'),
    ]
    profile: Annotated[
        Optional[TableProfile],
        Field(None, description='Latest Data profile for a table.'),
    ]
    testSuite: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Executable test suite associated with this table'),
    ]
    dataModel: Annotated[
        Optional[DataModel],
        Field(
            None,
            description='This captures information about how the table is modeled. Currently only DBT model is supported.',
        ),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    retentionPeriod: Annotated[
        Optional[basic.Duration],
        Field(
            None,
            description='Retention period of the data in the table. Period is expressed as duration in ISO 8601 format in UTC. Example - `P23DT23H`. When not set, the retention period is inherited from the parent database schema, if it exists.',
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl], Field(None, description='Source URL of table.')
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    fileFormat: Annotated[
        Optional[FileFormat],
        Field(None, description='File format in case of file/datalake tables.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    processedLineage: Annotated[
        Optional[bool], Field(False, description='Processed lineage for the table')
    ]


Column.model_rebuild()
