# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/deltaLakeConnection.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .. import connectionBasicType
from .deltalake import metastoreConfig, storageConfig


class DeltaLakeType(Enum):
    DeltaLake = 'DeltaLake'


class DeltaLakeConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DeltaLakeType],
        Field(
            DeltaLakeType.DeltaLake, description='Service Type', title='Service Type'
        ),
    ]
    configSource: Annotated[
        Union[metastoreConfig.MetastoreConfig, storageConfig.StorageConfig],
        Field(
            description='Available sources to fetch the metadata.',
            title='DeltaLake Configuration Source',
        ),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(
            None,
            description='If using Metastore, Key-Value pairs that will be used to add configs to the SparkSession.',
            title='Connection Arguments',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
