# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/domoDatabaseConnection.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class DomoDatabaseType(Enum):
    DomoDatabase = 'DomoDatabase'


class DomoDatabaseConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DomoDatabaseType],
        Field(
            DomoDatabaseType.DomoDatabase,
            description='Service Type',
            title='Service Type',
        ),
    ]
    clientId: Annotated[str, Field(description='Client ID for DOMO', title='Client ID')]
    secretToken: Annotated[
        CustomSecretStr,
        Field(description='Secret Token to connect DOMO', title='Secret Token'),
    ]
    accessToken: Annotated[
        Optional[str],
        Field(
            None, description='Access token to connect to DOMO', title='Access Token'
        ),
    ]
    apiHost: Annotated[
        Optional[str],
        Field(
            'api.domo.com',
            description='API Host to connect to DOMO instance',
            title='API Host',
        ),
    ]
    instanceDomain: Annotated[
        AnyUrl,
        Field(
            description='URL of your Domo instance, e.g., https://openmetadata.domo.com',
            title='Instance Domain',
        ),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
