# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/iceberg/restCatalogConnection.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from ...common import sslCertPaths
from . import icebergFileSystem


class Credential(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    clientId: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='OAuth2 Client ID.', title='Client ID'),
    ]
    clientSecret: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='OAuth2 Client Secret', title='Client Secret'),
    ]


class Sigv4(BaseModel):
    signingRegion: Annotated[
        Optional[str],
        Field(
            None,
            description='AWS Region to use when SigV4 signs a request.',
            title='Signing AWS Region',
        ),
    ]
    signingName: Annotated[
        Optional[str],
        Field(
            None,
            description='The service signing name to use when SigV4 signs a request.',
            title='Signing Name',
        ),
    ]


class RestCatalogConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    uri: Annotated[
        AnyUrl,
        Field(
            description="Uri to the REST catalog. Example: 'http://rest-catalog/ws/'",
            title='URI',
        ),
    ]
    credential: Annotated[
        Optional[Credential],
        Field(
            None,
            description='OAuth2 credential to use when initializing the catalog.',
            title='OAuth2 Credential',
        ),
    ]
    token: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description="Berarer token to use for the 'Authorization' header.",
            title='Token',
        ),
    ]
    ssl: Annotated[
        Optional[sslCertPaths.SslCertificatesByPath],
        Field(None, description='SSL Configuration details.', title='SSL'),
    ]
    sigv4: Annotated[
        Optional[Sigv4],
        Field(
            None,
            description='Sign requests to the REST Server using AWS SigV4 protocol.',
            title='Sigv4',
        ),
    ]
    fileSystem: Optional[icebergFileSystem.IcebergFileSystem] = None
