# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/icebergConnection.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .. import connectionBasicType
from .iceberg import icebergCatalog


class IcebergType(Enum):
    Iceberg = 'Iceberg'


class IcebergConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[IcebergType],
        Field(IcebergType.Iceberg, description='Service Type', title='Service Type'),
    ]
    catalog: icebergCatalog.IcebergCatalog
    ownershipProperty: Annotated[
        Optional[str],
        Field(
            'owner',
            description='Table property to look for the Owner.',
            title='Ownership Property',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
