# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/impalaConnection.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class AuthMechanism(Enum):
    NOSASL = 'NOSASL'
    PLAIN = 'PLAIN'
    GSSAPI = 'GSSAPI'
    LDAP = 'LDAP'
    JWT = 'JWT'


class ImpalaType(Enum):
    Impala = 'Impala'


class ImpalaScheme(Enum):
    impala = 'impala'
    impala4 = 'impala4'


class ImpalaConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[ImpalaType],
        Field(ImpalaType.Impala, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[ImpalaScheme],
        Field(
            ImpalaScheme.impala,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        Optional[str],
        Field(
            None,
            description='Username to connect to Impala. This user should have privileges to read all the metadata in Impala.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='Password to connect to Impala.', title='Password'),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the Impala service.', title='Host and Port'
        ),
    ]
    authMechanism: Annotated[
        Optional[AuthMechanism],
        Field(
            AuthMechanism.PLAIN,
            description='Authentication mode to connect to Impala.',
            title='Authentication Mode',
        ),
    ]
    kerberosServiceName: Annotated[
        Optional[str],
        Field(
            None,
            description='If authenticating with Kerberos specify the Kerberos service name',
            title='Kerberos Service Name',
        ),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(
            None,
            description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
            title='Database Schema',
        ),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    useSSL: Annotated[
        Optional[bool],
        Field(
            None, description='Establish secure connection with Impala', title='Use SSL'
        ),
    ]
    authOptions: Annotated[
        Optional[str],
        Field(
            None,
            description='Authentication options to pass to Impala connector. These options are based on SQLAlchemy.',
            title='URL Authentication Options',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
    supportsViewLineageExtraction: Optional[
        connectionBasicType.SupportsViewLineageExtraction
    ] = None
