# generated by datamodel-codegen:
#   filename:  entity/services/connections/messaging/kinesisConnection.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import awsCredentials
from .. import connectionBasicType


class KinesisType(Enum):
    Kinesis = 'Kinesis'


class KinesisConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[KinesisType],
        Field(KinesisType.Kinesis, description='Service Type', title='Service Type'),
    ]
    awsConfig: Annotated[
        awsCredentials.AWSCredentials, Field(title='AWS Credentials Configuration')
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
