# generated by datamodel-codegen:
#   filename:  governance/workflows/elements/nodes/userTask/userApprovalTask.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......type import basic


class Assignees(BaseModel):
    addReviewers: Annotated[
        Optional[bool],
        Field(False, description='Add the Reviewers to the assignees List.'),
    ]


class Config(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    assignees: Annotated[
        Assignees, Field(description='People/Teams assigned to the Task.')
    ]


class UserApprovalTaskDefinition(BaseModel):
    type: Optional[str] = 'userTask'
    subType: Optional[str] = 'userApprovalTask'
    name: Annotated[
        Optional[basic.EntityName],
        Field(None, description='Name that identifies this Node.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this Node.'),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the Node.')
    ]
    config: Optional[Config] = None
    input: Annotated[
        Optional[List[str]], Field(['relatedEntity'], max_length=1, min_length=1)
    ]
    output: Annotated[
        Optional[List[str]], Field(['result', 'resolvedBy'], max_length=2, min_length=2)
    ]
