# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceProfilerPipeline.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..entity.data import table
from ..type import filterPattern


class ProfilerConfigType(Enum):
    Profiler = 'Profiler'


class DatabaseServiceProfilerPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[ProfilerConfigType],
        Field(ProfilerConfigType.Profiler, description='Pipeline type'),
    ]
    classificationFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only compute metrics for table that matches the given tag, tiers, gloassary pattern.',
            title='Classification Filter Pattern',
        ),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch tables or databases that matches the pattern.',
            title='Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude tables or databases that matches the pattern.',
            title='Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch databases that matches the pattern.',
            title='Database Filter Pattern',
        ),
    ]
    includeViews: Annotated[
        Optional[bool],
        Field(
            False,
            description='Optional configuration to turn off fetching metadata for views.',
            title='Include Views',
        ),
    ]
    useFqnForFiltering: Annotated[
        Optional[bool],
        Field(
            False,
            description='Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)',
            title='Use FQN For Filtering',
        ),
    ]
    computeMetrics: Annotated[
        Optional[bool],
        Field(
            True,
            description='Option to turn on/off computing profiler metrics.',
            title='Compute Metrics',
        ),
    ]
    computeTableMetrics: Annotated[
        Optional[bool],
        Field(
            True,
            description='Option to turn on/off table metric computation. If enabled, profiler will compute table level metrics.',
            title='Compute Table Metrics',
        ),
    ]
    computeColumnMetrics: Annotated[
        Optional[bool],
        Field(
            True,
            description='Option to turn on/off column metric computation. If enabled, profiler will compute column level metrics.',
            title='Compute Column Metrics',
        ),
    ]
    useStatistics: Annotated[
        Optional[bool],
        Field(
            False,
            description='Use system tables to extract metrics. Metrics that cannot be gathered from system tables will use the default methods. Using system tables can be faster but requires gathering statistics before running (for example using the ANALYZE procedure). More information can be found in the documentation: https://docs.openmetadata.org/latest/profler',
            title='Use Gathered Statistics',
        ),
    ]
    profileSampleType: Annotated[
        Optional[table.ProfileSampleType],
        Field(table.ProfileSampleType.PERCENTAGE, title='Profile Sample Type'),
    ]
    profileSample: Annotated[
        Optional[float],
        Field(
            None,
            description='Percentage of data or no. of rows used to compute the profiler metrics and run data quality tests',
            title='Profile Sample',
        ),
    ]
    samplingMethodType: Annotated[
        Optional[table.SamplingMethodType], Field(None, title='Sampling Method Type')
    ]
    threadCount: Annotated[
        Optional[float],
        Field(
            5,
            description='Number of threads to use during metric computations',
            title='Thread Count',
        ),
    ]
    timeoutSeconds: Annotated[
        Optional[int],
        Field(
            43200, description='Profiler Timeout in Seconds', title='Timeout (in sec.)'
        ),
    ]
