# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceQueryUsagePipeline.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class DatabaseUsageConfigType(Enum):
    DatabaseUsage = 'DatabaseUsage'


class DatabaseServiceQueryUsagePipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DatabaseUsageConfigType],
        Field(DatabaseUsageConfigType.DatabaseUsage, description='Pipeline type'),
    ]
    queryLogDuration: Annotated[
        Optional[int],
        Field(
            1,
            description='Configuration to tune how far we want to look back in query logs to process usage data.',
            title='Query Log Duration',
        ),
    ]
    stageFileLocation: Annotated[
        Optional[str],
        Field(
            '/tmp/query_log',
            description='Temporary file name to store the query logs before processing. Absolute file path required.',
            title='Stage File Location',
        ),
    ]
    filterCondition: Annotated[
        Optional[str],
        Field(
            None,
            description='Configuration the condition to filter the query history.',
            title='Filter Condition',
        ),
    ]
    resultLimit: Annotated[
        Optional[int],
        Field(
            1000,
            description='Configuration to set the limit for query logs',
            title='Result Limit',
        ),
    ]
    queryLogFilePath: Annotated[
        Optional[str],
        Field(
            None,
            description='Configuration to set the file path for query logs',
            title='Query Log File Path',
        ),
    ]
