# generated by datamodel-codegen:
#   filename:  tests/dataQualityReport.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from typing import Dict, List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class DataQualityReportMetadata(BaseModel):
    keys: Annotated[
        Optional[List[str]],
        Field(None, description='Keys to identify the data quality report.'),
    ]
    dimensions: Annotated[
        Optional[List[str]],
        Field(None, description='Dimensions to capture the data quality report.'),
    ]
    metrics: Annotated[
        Optional[List[str]],
        Field(None, description='Metrics to capture the data quality report.'),
    ]


class DataQualityReport(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metadata: Annotated[
        DataQualityReportMetadata,
        Field(description='Metadata for the data quality report.'),
    ]
    data: Annotated[
        List[Dict[str, str]], Field(description='Data for the data quality report.')
    ]
