# generated by datamodel-codegen:
#   filename:  tests/testSuite.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..api.tests import createTestSuite
from ..entity.services.connections import testConnectionResult
from ..type import basic, entityHistory, entityReference, entityReferenceList, tagLabel
from . import basic as basic_1


class ServiceType(Enum):
    TestSuite = 'TestSuite'


class TestSuiteConnection(BaseModel):
    config: None = None


class ResultSummary(BaseModel):
    testCaseName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Name of the test case.'),
    ]
    status: Annotated[
        Optional[basic_1.TestCaseStatus],
        Field(None, description='Status of the test case.'),
    ]
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Timestamp of the test case execution.'),
    ]


class TestSuite(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of this test suite instance.'),
    ]
    name: Annotated[
        createTestSuite.TestSuiteEntityName,
        Field(description='Name that identifies this test suite.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this test suite.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the test suite.'),
    ]
    tests: Optional[List[entityReference.EntityReference]] = None
    connection: Annotated[
        Optional[TestSuiteConnection],
        Field(
            None,
            description='TestSuite mock connection, since it needs to implement a Service.',
        ),
    ]
    testConnectionResult: Annotated[
        Optional[testConnectionResult.TestConnectionResult],
        Field(None, description='Result of the test connection.'),
    ]
    pipelines: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='References to pipelines deployed for this Test Suite to execute the tests.',
        ),
    ]
    serviceType: Annotated[
        Optional[ServiceType],
        Field(
            ServiceType.TestSuite,
            description='Type of database service such as MySQL, BigQuery, Snowflake, Redshift, Postgres...',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this TestCase definition.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    basic: Annotated[
        Optional[bool],
        Field(
            False,
            description='Indicates if the test suite is basic, i.e., the parent suite of a test and linked to an entity. Set on the backend.',
        ),
    ]
    executable: Annotated[
        Optional[bool], Field(None, description="DEPRECATED in 1.6.2: Use 'basic'")
    ]
    basicEntityReference: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Entity reference the test suite needs to execute the test against. Only applicable if the test suite is basic.',
        ),
    ]
    executableEntityReference: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description="DEPRECATED in 1.6.2: Use 'basicEntityReference'."),
    ]
    summary: Annotated[
        Optional[basic_1.TestSummary],
        Field(
            None,
            description='Summary of the previous day test cases execution for this test suite.',
        ),
    ]
    testCaseResultSummary: Annotated[
        Optional[List[ResultSummary]],
        Field(None, description='Summary of test case execution'),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the test Suite belongs to. When not set, the test Suite inherits the domain from the table it belongs to.',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(
            [],
            description='Tags for this test suite. This is an inherited field from the parent entity if the testSuite is native.',
        ),
    ]
    inherited: Annotated[
        Optional[bool],
        Field(
            False,
            description='Indicates if the test suite is inherited from a parent entity.',
        ),
    ]
