# generated by datamodel-codegen:
#   filename:  type/csvImportResult.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic


class RowCount(RootModel[int]):
    root: Annotated[int, Field(description='Type used to indicate row count', ge=0)]


class Index(RootModel[int]):
    root: Annotated[
        int,
        Field(
            description='Type used to indicate row number or field number. In CSV the indexes start with 1.',
            ge=1,
        ),
    ]


class CsvImportResult(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dryRun: Annotated[
        Optional[bool],
        Field(None, description='True if the CSV import has dryRun flag enabled'),
    ]
    status: Optional[basic.Status] = None
    abortReason: Annotated[
        Optional[str],
        Field(
            None,
            description='Reason why import was aborted. This is set only when the `status` field is set to `aborted`',
        ),
    ]
    numberOfRowsProcessed: Optional[RowCount] = None
    numberOfRowsPassed: Optional[RowCount] = None
    numberOfRowsFailed: Optional[RowCount] = None
    importResultsCsv: Annotated[
        Optional[str],
        Field(
            None, description='CSV file that captures the result of import operation.'
        ),
    ]
