# generated by datamodel-codegen:
#   filename:  type/tableQuery.json
#   timestamp: 2025-04-09T17:55:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic


class TableQuery(BaseModel):
    query: Annotated[str, Field(description='SQL query')]
    query_type: Annotated[Optional[str], Field(None, description='SQL query type')]
    exclude_usage: Annotated[
        Optional[bool],
        Field(
            None,
            description='Flag to check if query is to be excluded while processing usage',
        ),
    ]
    dialect: Annotated[Optional[str], Field(None, description='SQL dialect')]
    userName: Annotated[
        Optional[str],
        Field(None, description='Name of the user that executed the SQL query'),
    ]
    startTime: Annotated[
        Optional[str], Field(None, description='Start time of execution of SQL query')
    ]
    endTime: Annotated[
        Optional[str], Field(None, description='End time of execution of SQL query')
    ]
    analysisDate: Annotated[
        Optional[basic.DateTime],
        Field(None, description='Date of execution of SQL query'),
    ]
    aborted: Annotated[
        Optional[bool],
        Field(None, description='Flag to check if query was aborted during execution'),
    ]
    serviceName: Annotated[
        str, Field(description='Name that identifies this database service.')
    ]
    databaseName: Annotated[
        Optional[str],
        Field(None, description='Database associated with the table in the query'),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(None, description='Database schema of the associated with query'),
    ]
    duration: Annotated[
        Optional[float],
        Field(None, description='How long did the query took to run in milliseconds.'),
    ]


class TableQueries(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    queries: Annotated[
        Optional[List[TableQuery]],
        Field(None, description='Date of execution of SQL query'),
    ]
