"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2025 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia common message definitions for gRPC API.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Audio(google.protobuf.message.Message):
    """ Audio message in either raw or one of the standard formats.

     In the case of raw format, this message contains raw audio data that
     are encoded in a format specified in the configuration.
     The audio <code>content</code> is represented as raw audio if the
     <code>raw_audio_config</code> filed is specified.

     In case that the <code>raw_audio_config</code> is not specified, this
     message contains audio data in one of the supported standard formats
     and encodings. Supported formats are <code>WAV</code> (various encodings),
     <code>FLAC</code>, and <code>OGG_OPUS</code>.
     For best results, the audio source should be captured and transmitted
     using a lossless encoding (<code>FLAC</code> or <code>LINEAR16</code>).
     The accuracy of the speech technologies can be reduced if lossy codecs
     are used to capture or transmit audio, particularly if background noise
     is present. Lossy codecs include <code>ALAW</code>, <code>MULAW</code>,
     or <code>OGG_OPUS</code>.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    TIME_RANGE_FIELD_NUMBER: builtins.int
    RAW_AUDIO_CONFIG_FIELD_NUMBER: builtins.int
    content: builtins.bytes
    """The audio data bytes encoded in the supported format. In case of raw
    audio, this field does not include the audio header, but only the data.
    <em>Note: as with all bytes fields, proto buffers use a pure binary
    representation.</em>
    """
    @property
    def time_range(self) -> global___TimeRange:
        """Time range of the audio to process. If omitted, the
        whole audio is processed. If <code>start</code> is omitted, the
        audio is processed from the beginning. If <code>end</code> is omitted,
        the audio is processed to the end.
        """

    @property
    def raw_audio_config(self) -> global___RawAudioConfig:
        """Specify raw audio metadata in case that the <code>content</code> is in
        raw format.
        """

    def __init__(
        self,
        *,
        content: builtins.bytes = ...,
        time_range: global___TimeRange | None = ...,
        raw_audio_config: global___RawAudioConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["raw_audio_config", b"raw_audio_config", "time_range", b"time_range"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["content", b"content", "raw_audio_config", b"raw_audio_config", "time_range", b"time_range"]) -> None: ...

global___Audio = Audio

@typing.final
class RawAudioConfig(google.protobuf.message.Message):
    """ Configuration message for raw audio data used in <code>Audio</code> message."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AudioEncoding:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AudioEncodingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RawAudioConfig._AudioEncoding.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PCM16: RawAudioConfig._AudioEncoding.ValueType  # 0
        """16-bit signed little-endian linear Pulse Code Modulation"""
        PCM32: RawAudioConfig._AudioEncoding.ValueType  # 1
        """32-bit signed little-endian linear Pulse Code Modulation"""
        MULAW: RawAudioConfig._AudioEncoding.ValueType  # 2
        """μ-law encoding"""
        ALAW: RawAudioConfig._AudioEncoding.ValueType  # 3
        """A-law encoding"""

    class AudioEncoding(_AudioEncoding, metaclass=_AudioEncodingEnumTypeWrapper):
        """Enumeration of supported audio encodings for raw audio data."""

    PCM16: RawAudioConfig.AudioEncoding.ValueType  # 0
    """16-bit signed little-endian linear Pulse Code Modulation"""
    PCM32: RawAudioConfig.AudioEncoding.ValueType  # 1
    """32-bit signed little-endian linear Pulse Code Modulation"""
    MULAW: RawAudioConfig.AudioEncoding.ValueType  # 2
    """μ-law encoding"""
    ALAW: RawAudioConfig.AudioEncoding.ValueType  # 3
    """A-law encoding"""

    ENCODING_FIELD_NUMBER: builtins.int
    SAMPLE_RATE_HERTZ_FIELD_NUMBER: builtins.int
    CHANNELS_FIELD_NUMBER: builtins.int
    encoding: global___RawAudioConfig.AudioEncoding.ValueType
    """The encoding of the audio data. This field determines how the raw audio
    data is interpreted.
    """
    sample_rate_hertz: builtins.int
    """The sample rate in hertz (Hz) of the audio data. This field specifies
    the number of audio samples per second. Most Phonexia technologies resample
    the audio into 8kHz or 16kHz as a first step.
    """
    channels: builtins.int
    """The number of channels in the audio data.
    <em>Note: some technologies only support mono-channel audio recordings.
    Setting this field to values other than 1 will result in an error for
    such technologies.</em>
    """
    def __init__(
        self,
        *,
        encoding: global___RawAudioConfig.AudioEncoding.ValueType = ...,
        sample_rate_hertz: builtins.int = ...,
        channels: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channels", b"channels", "encoding", b"encoding", "sample_rate_hertz", b"sample_rate_hertz"]) -> None: ...

global___RawAudioConfig = RawAudioConfig

@typing.final
class Voiceprint(google.protobuf.message.Message):
    """Represents the result from voiceprint extraction."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    content: builtins.bytes
    """Voiceprint data bytes encoded in UBJSON format."""
    def __init__(
        self,
        *,
        content: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["content", b"content"]) -> None: ...

global___Voiceprint = Voiceprint

@typing.final
class Matrix(google.protobuf.message.Message):
    """Data type representing matrix of values. The matrix is represented as a
    linear array in row major format.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROWS_COUNT_FIELD_NUMBER: builtins.int
    COLUMNS_COUNT_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    rows_count: builtins.int
    """Number of rows in the matrix."""
    columns_count: builtins.int
    """Number of columns in the matrix."""
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Sequential list of matrix values in row major format."""

    def __init__(
        self,
        *,
        rows_count: builtins.int = ...,
        columns_count: builtins.int = ...,
        values: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["columns_count", b"columns_count", "rows_count", b"rows_count", "values", b"values"]) -> None: ...

global___Matrix = Matrix

@typing.final
class TimeRange(google.protobuf.message.Message):
    """Data type representing time range."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    @property
    def start(self) -> google.protobuf.duration_pb2.Duration:
        """Start time of the time range."""

    @property
    def end(self) -> google.protobuf.duration_pb2.Duration:
        """End time of the time range."""

    def __init__(
        self,
        *,
        start: google.protobuf.duration_pb2.Duration | None = ...,
        end: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end", b"end", "start", b"start"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["end", b"end", "start", b"start"]) -> None: ...

global___TimeRange = TimeRange
