"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2025 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Age Estimation gRPC API.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class EstimateRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>Estimate</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VOICEPRINTS_FIELD_NUMBER: builtins.int
    AUDIO_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def voiceprints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[phonexia.grpc.common.core_pb2.Voiceprint]:
        """List of voiceprints for the estimation."""

    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio data from which age is to be estimated.
        The audio should have minimum length of at least 0.3 seconds. If the audio is shorter,
        the <code>result</code> will not be present in the output.
        """

    @property
    def config(self) -> global___EstimateConfig:
        """Configuration for the age estimation."""

    def __init__(
        self,
        *,
        voiceprints: collections.abc.Iterable[phonexia.grpc.common.core_pb2.Voiceprint] | None = ...,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
        config: global___EstimateConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio", "config", b"config", "voiceprints", b"voiceprints"]) -> None: ...

global___EstimateRequest = EstimateRequest

@typing.final
class EstimateConfig(google.protobuf.message.Message):
    """Message used for configuration of the <code>Estimate</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Specifies the maximum speech length from which the age will be estimated.
        If there is less speech in the audio than the specified duration, the age
        will be estimated from the entire audio. This option is applicable only for Audio
        data.
        """

    def __init__(
        self,
        *,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["speech_length", b"speech_length"]) -> None: ...

global___EstimateConfig = EstimateConfig

@typing.final
class EstimateResult(google.protobuf.message.Message):
    """An age estimation result."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGE_FIELD_NUMBER: builtins.int
    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    age: builtins.int
    """Estimated age.
    This field is not set if not enough speech has been provided.
    """
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total speech length from which the age was estimated."""

    def __init__(
        self,
        *,
        age: builtins.int | None = ...,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_age", b"_age", "age", b"age", "speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_age", b"_age", "age", b"age", "speech_length", b"speech_length"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_age", b"_age"]) -> typing.Literal["age"] | None: ...

global___EstimateResult = EstimateResult

@typing.final
class EstimateResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Estimate</code>
    method. It contains the result as one or more <code>EstimateResult</code>
    messages.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULTS_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EstimateResult]:
        """Sequential list of results corresponding to sequential list of voiceprints
        in <code>EstimateRequest</code>. Contains single result when using audio.
        """

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """When available, total length of the processed audio.
        Set only if audio is used in <code>EstimateRequest</code>.
        """

    def __init__(
        self,
        *,
        results: collections.abc.Iterable[global___EstimateResult] | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "results", b"results"]) -> None: ...

global___EstimateResponse = EstimateResponse
