"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2025 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Deepfake Detection gRPC API.
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class DetectRequest(google.protobuf.message.Message):
    """The top level message sent by the client for the <code>Detect</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio data for deepfake detection.
        The audio should have minimum length of 3 seconds. If the audio is shorter,
        the <code>result</code> will not be present in the output.
        """

    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio"]) -> None: ...

global___DetectRequest = DetectRequest

@typing.final
class DetectResponse(google.protobuf.message.Message):
    """The top level message returned to the client by the <code>Detect</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___DetectResult:
        """Result of deepfake detection. Will not be present if the audio is shorter than 3 seconds."""

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total length of the processed audio."""

    def __init__(
        self,
        *,
        result: global___DetectResult | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_result", b"_result", "processed_audio_length", b"processed_audio_length", "result", b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_result", b"_result", "processed_audio_length", b"processed_audio_length", "result", b"result"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_result", b"_result"]) -> typing.Literal["result"] | None: ...

global___DetectResponse = DetectResponse

@typing.final
class DetectResult(google.protobuf.message.Message):
    """Message representing the result of deepfake detection."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCORE_FIELD_NUMBER: builtins.int
    score: builtins.float
    """Score of the deepfake detection. A higher score indicates a higher
    likelihood of the audio being a deepfake. The score is a floating-point
    value. While technically limited by floating-point representation,
    scores are typically within a certain range that varies model to model.
    """
    def __init__(
        self,
        *,
        score: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["score", b"score"]) -> None: ...

global___DetectResult = DetectResult
