"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2025 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Language Identification gRPC API.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class IdentifyRequest(google.protobuf.message.Message):
    """The top level message sent by the client for the <code>Identify</code> method.
    The method accepts either Audio data or Languageprint.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    LANGUAGEPRINT_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio data in which language is to be identified.
        The audio should contain at least 0.3125 seconds of speech. If the audio contains less speech,
        the <code>scores</code> will be empty.
        """

    @property
    def config(self) -> global___IdentifyConfig:
        """Configuration for the language identification."""

    @property
    def languageprint(self) -> global___Languageprint:
        """Languageprint in which language is to be identified."""

    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
        config: global___IdentifyConfig | None = ...,
        languageprint: global___Languageprint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio", "config", b"config", "languageprint", b"languageprint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio", "config", b"config", "languageprint", b"languageprint"]) -> None: ...

global___IdentifyRequest = IdentifyRequest

@typing.final
class IdentifyResponse(google.protobuf.message.Message):
    """The top level message returned to the client by the <code>Identify</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___LanguageIdentificationResult:
        """Result of language identification."""

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """When available, total length of the processed audio.
        Set only if this is the last response in the stream.
        """

    def __init__(
        self,
        *,
        result: global___LanguageIdentificationResult | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> None: ...

global___IdentifyResponse = IdentifyResponse

@typing.final
class ListSupportedLanguagesRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the
    <code>ListSupportedLanguages</code> method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___ListSupportedLanguagesConfig:
        """Configuration for the listing of supported languages."""

    def __init__(
        self,
        *,
        config: global___ListSupportedLanguagesConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config"]) -> None: ...

global___ListSupportedLanguagesRequest = ListSupportedLanguagesRequest

@typing.final
class ListSupportedLanguagesResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the
    <code>ListSupportedLanguages</code> method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUPPORTED_LANGUAGES_FIELD_NUMBER: builtins.int
    MODIFIED_LANGUAGES_FIELD_NUMBER: builtins.int
    ADDED_LANGUAGES_FIELD_NUMBER: builtins.int
    @property
    def supported_languages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of supported languages."""

    @property
    def modified_languages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Subset of <code>supported_languages</code> that were modified with custom data via
        language adaptation.
        """

    @property
    def added_languages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Subset of <code>supported_languages</code> that were added via language adaptation."""

    def __init__(
        self,
        *,
        supported_languages: collections.abc.Iterable[builtins.str] | None = ...,
        modified_languages: collections.abc.Iterable[builtins.str] | None = ...,
        added_languages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["added_languages", b"added_languages", "modified_languages", b"modified_languages", "supported_languages", b"supported_languages"]) -> None: ...

global___ListSupportedLanguagesResponse = ListSupportedLanguagesResponse

@typing.final
class ExtractRequest(google.protobuf.message.Message):
    """The top level message sent by the client for the <code>Extract</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio to extract the languageprint from.
        If the audio is in a raw format and the <code>config.speech_length</code> is
        set, the result can be returned before the whole audio was transferred if the
        requirements for speech length were met.
        The audio should contain at least 0.3125 seconds of speech. If the audio contains less speech,
        the resulted languageprint will be empty (contains 0s of speech).
        """

    @property
    def config(self) -> global___ExtractConfig:
        """Configuration for the languageprint extraction."""

    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
        config: global___ExtractConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> None: ...

global___ExtractRequest = ExtractRequest

@typing.final
class ExtractResponse(google.protobuf.message.Message):
    """The top level message returned to the client by the <code>Extract</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___ExtractResult:
        """Result containing the extracted languageprint."""

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """When available, total length of the processed audio.
        Set only if this is the last response in the stream.
        """

    def __init__(
        self,
        *,
        result: global___ExtractResult | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> None: ...

global___ExtractResponse = ExtractResponse

@typing.final
class AdaptRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>Adapt</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADAPTATION_UNITS_FIELD_NUMBER: builtins.int
    @property
    def adaptation_units(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AdaptationUnit]:
        """Data (languageprints, metadata) used for the supervised adaptation."""

    def __init__(
        self,
        *,
        adaptation_units: collections.abc.Iterable[global___AdaptationUnit] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["adaptation_units", b"adaptation_units"]) -> None: ...

global___AdaptRequest = AdaptRequest

@typing.final
class AdaptResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Adapt</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___AdaptationResult:
        """Result of language adaptation."""

    def __init__(
        self,
        *,
        result: global___AdaptationResult | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["result", b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["result", b"result"]) -> None: ...

global___AdaptResponse = AdaptResponse

@typing.final
class IdentifyConfig(google.protobuf.message.Message):
    """Message used for configuration of the <code>Identify</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    LANGUAGES_FIELD_NUMBER: builtins.int
    GROUPS_FIELD_NUMBER: builtins.int
    ADAPTATION_PROFILE_FIELD_NUMBER: builtins.int
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Specifies the maximum speech length from which the languages will be identified.
        If there is less speech in the audio than the specified duration, the languages
        will be identified from the entire audio. This option is applicable only for Audio
        data.
        """

    @property
    def languages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Language]:
        """Specify which languages can be used for language identification.
        Choose only from list of supported languages, which can be retrieved at
        <code>ListSupportedLanguages</code>. Choosing desired languages redistributes
        the probabilities of excluded languages into the rest of languages relative
        to their scores. Excluding a dialect of a language may however result in
        inaccurate scores for other dialects in cases when the excluded dialect would
        have a probability score close to 1. Leaving this field empty is the same as
        selecting every supported language.
        """

    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LanguageGroup]:
        """Create custom groups of languages and assign them a common identifier.
        By defining a group a new entity that encapsulates the group languages is
        created. This group holds the scores of the individual languages as well as
        their sum. One of the use cases for using groups may be grouping individual
        language dialects into one encapsulating group. Groups of languages mustn't
        intersect, that means a language can only be part of at most one group.
        """

    @property
    def adaptation_profile(self) -> global___AdaptationProfile:
        """Adapt the model with language adaptation obtained via the <code>Adapt</code>
        method. Be careful to only send this field with the first message of the stream,
        as it is several kilobytes in size.
        """

    def __init__(
        self,
        *,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
        languages: collections.abc.Iterable[global___Language] | None = ...,
        groups: collections.abc.Iterable[global___LanguageGroup] | None = ...,
        adaptation_profile: global___AdaptationProfile | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["adaptation_profile", b"adaptation_profile", "speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["adaptation_profile", b"adaptation_profile", "groups", b"groups", "languages", b"languages", "speech_length", b"speech_length"]) -> None: ...

global___IdentifyConfig = IdentifyConfig

@typing.final
class ListSupportedLanguagesConfig(google.protobuf.message.Message):
    """Message used for configuration of the <code>ListSupportedLanguages</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADAPTATION_PROFILE_FIELD_NUMBER: builtins.int
    @property
    def adaptation_profile(self) -> global___AdaptationProfile:
        """Adapt the model with language adaptation obtained via the <code>Adapt</code>
        method. The returned list will then contain all built-in languages as well as
        languages modified and newly added using the language adaptation.
        """

    def __init__(
        self,
        *,
        adaptation_profile: global___AdaptationProfile | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["adaptation_profile", b"adaptation_profile"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["adaptation_profile", b"adaptation_profile"]) -> None: ...

global___ListSupportedLanguagesConfig = ListSupportedLanguagesConfig

@typing.final
class ExtractConfig(google.protobuf.message.Message):
    """Message used for configuration of the <code>Extract</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Specifies the maximum speech length from which the languageprint may be extracted.
        If there is less speech in the audio than the specified duration, the languageprint
        will be extracted from the entire audio.
        """

    def __init__(
        self,
        *,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["speech_length", b"speech_length"]) -> None: ...

global___ExtractConfig = ExtractConfig

@typing.final
class Language(google.protobuf.message.Message):
    """Message for selecting specific language."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    language_code: builtins.str
    """Language code in RFC 5646 format."""
    def __init__(
        self,
        *,
        language_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["language_code", b"language_code"]) -> None: ...

global___Language = Language

@typing.final
class LanguageGroup(google.protobuf.message.Message):
    """Message defining language group. Group several languages and assigns them common
    identifier. Defining group produces score for the individual languages as well as
    for the language groups.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDENTIFIER_FIELD_NUMBER: builtins.int
    LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    identifier: builtins.str
    """Identifier of created group.
    This identifier will be used in <code>LanguageIdentificationScore</code>.
    Group identifier must be unique among all groups and languages.
    """
    @property
    def language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Set of languages forming this group."""

    def __init__(
        self,
        *,
        identifier: builtins.str = ...,
        language_codes: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["identifier", b"identifier", "language_codes", b"language_codes"]) -> None: ...

global___LanguageGroup = LanguageGroup

@typing.final
class Languageprint(google.protobuf.message.Message):
    """Represents the result from languageprint extraction."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    content: builtins.bytes
    """Languageprint data encoded in UBJSON format."""
    def __init__(
        self,
        *,
        content: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["content", b"content"]) -> None: ...

global___Languageprint = Languageprint

@typing.final
class LanguageIdentificationResult(google.protobuf.message.Message):
    """Message representing the result of language identification."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    SCORES_FIELD_NUMBER: builtins.int
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Speech length from which the languageprint was extracted."""

    @property
    def scores(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LanguageIdentificationScore]:
        """List of scores for each selected language and language group.
        This list holds N elements, where:
        N = (number of supported languages) + (number of groups) - (number of languages
        defined within groups).

        Example: For 140 supported languages and 2 groups each containing 4 unique
        languages this field holds: 140 + 2 - (2 * 4) = 134 elements including 132
        languages and 2 groups. Scores of the individual languages from the groups
        are embedded within the groups.
        """

    def __init__(
        self,
        *,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
        scores: collections.abc.Iterable[global___LanguageIdentificationScore] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["scores", b"scores", "speech_length", b"speech_length"]) -> None: ...

global___LanguageIdentificationResult = LanguageIdentificationResult

@typing.final
class LanguageIdentificationScore(google.protobuf.message.Message):
    """Score for a single language or language group."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _IdentifierType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _IdentifierTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LanguageIdentificationScore._IdentifierType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LANGUAGE: LanguageIdentificationScore._IdentifierType.ValueType  # 0
        """The identifier specifies a single language (built-in or adapted)"""
        GROUP: LanguageIdentificationScore._IdentifierType.ValueType  # 1
        """The identifier specifies a user-defined group of languages."""

    class IdentifierType(_IdentifierType, metaclass=_IdentifierTypeEnumTypeWrapper):
        """Enumeration of supported identifier types."""

    LANGUAGE: LanguageIdentificationScore.IdentifierType.ValueType  # 0
    """The identifier specifies a single language (built-in or adapted)"""
    GROUP: LanguageIdentificationScore.IdentifierType.ValueType  # 1
    """The identifier specifies a user-defined group of languages."""

    IDENTIFIER_FIELD_NUMBER: builtins.int
    PROBABILITY_FIELD_NUMBER: builtins.int
    LANGUAGES_FIELD_NUMBER: builtins.int
    IDENTIFIER_TYPE_FIELD_NUMBER: builtins.int
    identifier: builtins.str
    """This field contains either a language identifier or a language group identifier.
    Language identifiers may be specified by a RFC 5646 code for built-in languages or
    by a custom identifier for languages added via language adaptation.
    """
    probability: builtins.float
    """Score for this language or language group.
    The score represents the probability of the input belonging to a particular
    language/group.
    Language group probability is the sum of the probabilities of its languages.
    """
    identifier_type: global___LanguageIdentificationScore.IdentifierType.ValueType
    """This field explicitly identifies the score as belonging to either an individual
    language or a language group.
    """
    @property
    def languages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LanguageIdentificationScore]:
        """This field is only set for language groups.
        Scores for individual languages that this group is comprised of can be found in
        this field.
        """

    def __init__(
        self,
        *,
        identifier: builtins.str = ...,
        probability: builtins.float = ...,
        languages: collections.abc.Iterable[global___LanguageIdentificationScore] | None = ...,
        identifier_type: global___LanguageIdentificationScore.IdentifierType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["identifier", b"identifier", "identifier_type", b"identifier_type", "languages", b"languages", "probability", b"probability"]) -> None: ...

global___LanguageIdentificationScore = LanguageIdentificationScore

@typing.final
class ExtractResult(google.protobuf.message.Message):
    """A languageprint extraction result."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    LANGUAGEPRINT_FIELD_NUMBER: builtins.int
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Speech length from which the languageprint was extracted."""

    @property
    def languageprint(self) -> global___Languageprint:
        """Extracted languageprint."""

    def __init__(
        self,
        *,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
        languageprint: global___Languageprint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["languageprint", b"languageprint", "speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["languageprint", b"languageprint", "speech_length", b"speech_length"]) -> None: ...

global___ExtractResult = ExtractResult

@typing.final
class AdaptationUnit(google.protobuf.message.Message):
    """A unit used for language adaptation. Language adaptation is typically performed with
    many adaptation units. Each unit must be assigned to either an existing language to
    adapt its accuracy on new data, or to a new identifier to create a new language in
    the language identification.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGEPRINT_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    @property
    def languageprint(self) -> global___Languageprint:
        """Languageprint containing the data for adaptation."""

    @property
    def language(self) -> global___Language:
        """The language contained in the languageprint recording.
        By selecting a built-in language, this language will be modified for better
        performance on custom data.
        By selecting a new language, the system will add this language to the possible
        languages for language identification.
        """

    def __init__(
        self,
        *,
        languageprint: global___Languageprint | None = ...,
        language: global___Language | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["language", b"language", "languageprint", b"languageprint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["language", b"language", "languageprint", b"languageprint"]) -> None: ...

global___AdaptationUnit = AdaptationUnit

@typing.final
class AdaptationProfile(google.protobuf.message.Message):
    """Message containing the language adaptation profile. We recommend to store the
    original audio data, as the <code>AdaptationProfile</code> created for a specific
    version of Language Identification may not work with a different version and
    thus the <code>AdaptationProfile</code> would need to be created anew.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    content: builtins.bytes
    """The data of the language adaptation profile."""
    def __init__(
        self,
        *,
        content: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["content", b"content"]) -> None: ...

global___AdaptationProfile = AdaptationProfile

@typing.final
class AdaptationResult(google.protobuf.message.Message):
    """Message representing the result of language adaptation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADAPTATION_PROFILE_FIELD_NUMBER: builtins.int
    MODIFIED_LANGUAGES_FIELD_NUMBER: builtins.int
    ADDED_LANGUAGES_FIELD_NUMBER: builtins.int
    @property
    def adaptation_profile(self) -> global___AdaptationProfile:
        """A structure containing the resulting adaptation data for the technology."""

    @property
    def modified_languages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Built-in languages that were modified by the adaptation."""

    @property
    def added_languages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """New languages that were added by the adaptation."""

    def __init__(
        self,
        *,
        adaptation_profile: global___AdaptationProfile | None = ...,
        modified_languages: collections.abc.Iterable[builtins.str] | None = ...,
        added_languages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["adaptation_profile", b"adaptation_profile"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["adaptation_profile", b"adaptation_profile", "added_languages", b"added_languages", "modified_languages", b"modified_languages"]) -> None: ...

global___AdaptationResult = AdaptationResult
