"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2025 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Speaker Diarization gRPC API
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class DiarizeRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>Diarize</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio to be diarized.
        The audio should have minimum length of 0.8 seconds. If the audio is shorter,
        the <code>segments</code> will be empty.
        """

    @property
    def config(self) -> global___DiarizeConfig:
        """Speaker diarization configuration."""

    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
        config: global___DiarizeConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> None: ...

global___DiarizeRequest = DiarizeRequest

@typing.final
class DiarizeConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_SPEAKERS_FIELD_NUMBER: builtins.int
    TOTAL_SPEAKERS_FIELD_NUMBER: builtins.int
    max_speakers: builtins.int
    """Upper limit for the number of speakers in the audio.
    The value must be larger than 0.
    If omitted, the default value is set to 100.
    """
    total_speakers: builtins.int
    """Enforces exact number of speakers in the audio. If set, it overwrites
    <code>max_speakers</code>. If not set, the number of speakers
    is detected automatically, with upper limit defined by
    <code>max_speakers</code>.
    """
    def __init__(
        self,
        *,
        max_speakers: builtins.int | None = ...,
        total_speakers: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_max_speakers", b"_max_speakers", "_total_speakers", b"_total_speakers", "max_speakers", b"max_speakers", "total_speakers", b"total_speakers"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_max_speakers", b"_max_speakers", "_total_speakers", b"_total_speakers", "max_speakers", b"max_speakers", "total_speakers", b"total_speakers"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_max_speakers", b"_max_speakers"]) -> typing.Literal["max_speakers"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_total_speakers", b"_total_speakers"]) -> typing.Literal["total_speakers"] | None: ...

global___DiarizeConfig = DiarizeConfig

@typing.final
class DiarizeResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Diarize</code>
    method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEAKERS_COUNT_FIELD_NUMBER: builtins.int
    SEGMENTS_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    speakers_count: builtins.int
    """Detected number of speakers in the audio."""
    @property
    def segments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Segment]:
        """List of detected segments in the audio. Will be empty if the audio is shorter than 0.8 seconds."""

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total length of the processed audio."""

    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total Speech length of the processed audio."""

    def __init__(
        self,
        *,
        speakers_count: builtins.int = ...,
        segments: collections.abc.Iterable[global___Segment] | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "segments", b"segments", "speakers_count", b"speakers_count", "speech_length", b"speech_length"]) -> None: ...

global___DiarizeResponse = DiarizeResponse

@typing.final
class Segment(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEAKER_ID_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    speaker_id: builtins.int
    """Identifier of a speaker in the segment."""
    @property
    def start_time(self) -> google.protobuf.duration_pb2.Duration:
        """Start time of the segment."""

    @property
    def end_time(self) -> google.protobuf.duration_pb2.Duration:
        """End time of the segment."""

    def __init__(
        self,
        *,
        speaker_id: builtins.int = ...,
        start_time: google.protobuf.duration_pb2.Duration | None = ...,
        end_time: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["end_time", b"end_time", "speaker_id", b"speaker_id", "start_time", b"start_time"]) -> None: ...

global___Segment = Segment
